/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.partner.scheduling;

import com.ericsson.cms.scheduler.Node;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.util.LocalizedMessageUtil;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class Util {
    private static final String PARTNER = "Partner";
    private static final String PARTNER_NAME = "Name";
    private static final String PARTNER_ID = "Id";
    private static final String PARTNER_TYPE = "Type";
    private static final String PARTNER_PROVIDERID = "ProviderId";
    private static final String PARTNER_CONTEXT_ID = "ContextId";
    private static final String PARTNER_EMAIL_ID = "EmailId";
    static final char NODE_SEP = '.';
    private static final SimpleDateFormat WORKFLOW_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private static LocalizedMessageUtil messageUtil = new LocalizedMessageUtil("schedule");

    Util() {
    }

    static Node getPartnerParameters() {
        Node root = new Node(PARTNER, messageUtil.getMessageValue("scheduleFieldSelector.Partner"));
        root.addChild(new Node(PARTNER_ID, messageUtil.getMessageValue("scheduleFieldSelector.Partner.Id")));
        root.addChild(new Node(PARTNER_NAME, messageUtil.getMessageValue("scheduleFieldSelector.Partner.Name")));
        root.addChild(new Node(PARTNER_TYPE, messageUtil.getMessageValue("scheduleFieldSelector.Partner.Type")));
        root.addChild(new Node(PARTNER_PROVIDERID, messageUtil.getMessageValue("scheduleFieldSelector.Partner.ProviderId")));
        root.addChild(new Node(PARTNER_CONTEXT_ID, messageUtil.getMessageValue("scheduleFieldSelector.Partner.ContextId")));
        root.addChild(new Node(PARTNER_EMAIL_ID, messageUtil.getMessageValue("scheduleFieldSelector.Partner.EmailId")));
        return root;
    }

    static Map<String, String> getPartnerParameterValues(long partnerId) {
        return Util.getPartnerParameterValues(Util.getPartner(partnerId));
    }

    static Map<String, String> getPartnerParameterValues(Partner partner) {
        HashMap<String, String> refValues = new HashMap<String, String>();
        refValues.put("Partner.Id", String.valueOf(partner.getId()));
        refValues.put("Partner.Name", partner.getName());
        refValues.put("Partner.Type", partner.getType().name());
        refValues.put("Partner.ProviderId", partner.getProviderId());
        refValues.put("Partner.ContextId", String.valueOf(partner.getContainerContextId()));
        refValues.put("Partner.EmailId", partner.getContact().getEmail());
        return refValues;
    }

    static String formatForWorkflow(Date date) {
        return WORKFLOW_DATE_FORMAT.format(date);
    }

    static Partner getPartner(long partnerId) {
        IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        return partnerManager.getPartner(partnerId);
    }

    static void setTimeToStartOfTheDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        date.setTime(calendar.getTimeInMillis());
    }
}

