/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule;

import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.scheduler.ScheduleAssociatedEntityType;
import com.ericsson.cms.scheduler.ScheduleMessageBundle;
import com.ericsson.cms.scheduler.entities.Job;
import com.ericsson.cms.scheduler.entities.ScheduleRule;
import com.ericsson.cms.scheduler.entities.ScheduleRuleParameter;
import com.ericsson.cms.scheduler.entities.ScheduleRuleType;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.assetlist.AssetListPersistenceService;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.entities.ScheduleStatus;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.schedule.DistScheduleSchedulerCallback;
import com.tandbergtv.watchpoint.pmm.schedule.IDistSchedulePersistenceService;
import com.tandbergtv.watchpoint.pmm.schedule.ValidationErrors;
import com.tandbergtv.watchpoint.pmm.util.validation.ValidationException;
import com.tandbergtv.watchpoint.pmm.util.validation.ValidationMessage;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class DistSchedulePersistenceService
extends AssetListPersistenceService<DistributionSchedule>
implements IDistSchedulePersistenceService {
    private static final String ENTITY_TYPE = ScheduleAssociatedEntityType.DISTRIBUTION_SCHEDULE.getEntityType();
    private static final String JOB_NAME_PREFIX = ScheduleMessageBundle.getString((String)"scheduleNamePrefix.DistributionSchedule") + " ";
    private static final String JOB_ASSOCIATION_PREFIX = ScheduleMessageBundle.getString((String)"scheduleDiscriptionPrefix.DistributionSchedule") + " ";
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static DateFormat timeFormat = new SimpleDateFormat("h:mm a");

    public DistSchedulePersistenceService() {
        super("DistSchedule Persistence");
    }

    @Override
    @Transactional
    public DistributionSchedule save(DistributionSchedule ds) throws ValidationException {
        Partner p;
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        IPartnerManagement partnerManager = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        if (ds.getContextID() == null) {
            messages.add(ValidationErrors.CONTEXTID_REQUIRED.getValidationMessage(new String[0]));
        } else {
            p = partnerManager.getPartnerByContextId(ds.getContextID().longValue());
            if (p == null || p.getType() != PartnerType.DISTRIBUTION) {
                messages.add(ValidationErrors.NODISTPARTNER.getValidationMessage(ds.getContextID().toString()));
            }
        }
        if (ds.getSourcePartnerID() != null) {
            p = null;
            try {
                p = partnerManager.getPartner(ds.getSourcePartnerID().longValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (p == null || p.getType() != PartnerType.SOURCE) {
                messages.add(ValidationErrors.NOSRCPARTNER.getValidationMessage(ds.getSourcePartnerID().toString()));
            }
        }
        if (ds.getPitchDate() == null) {
            messages.add(ValidationErrors.PITCHDATE_REQUIRED.getValidationMessage(new String[0]));
        } else if (ds.getPitchDate().before(new Date())) {
            messages.add(ValidationErrors.PITCHDATE_PAST.getValidationMessage(new String[0]));
        }
        if (!messages.isEmpty()) {
            throw new ValidationException(messages);
        }
        boolean create = ds.getId() == null;
        DistributionSchedule savedDS = super.save(ds);
        List jobs = this.getScheduler().getJobsByAssociatedEntity(ENTITY_TYPE, ds.getId().longValue());
        if (create || jobs == null || jobs.isEmpty()) {
            Job job = new Job();
            job.setRule(this.getScheduleRule(savedDS.getDate()));
            job.setAssociatedEntityType(ENTITY_TYPE);
            HashSet<Long> entities = new HashSet<Long>();
            entities.add(savedDS.getId());
            job.setAssociatedEntities(entities);
            job.setName(JOB_NAME_PREFIX + savedDS.getId());
            job.setAssociationDescription(JOB_ASSOCIATION_PREFIX + savedDS.getId());
            job.setCallbackClass(DistScheduleSchedulerCallback.class);
            this.getScheduler().schedule(job);
        } else {
            Job job = (Job)jobs.get(0);
            this.getSession().evict((Object)job);
            if (this.isDifferent(job.getRule(), savedDS.getDate())) {
                job.setRule(this.getScheduleRule(savedDS.getDate()));
                this.getScheduler().schedule(job);
            }
        }
        return savedDS;
    }

    @Transactional
    public void changeStatus(long id, ScheduleStatus status) {
        if (status == null) {
            throw new RuntimeException("Cannot set the status to null");
        }
        DistributionSchedule ds = (DistributionSchedule)this.get(Long.valueOf(id));
        if (ds == null) {
            throw new RuntimeException("No distribution schedule exists for id: " + id);
        }
        ds.setStatus(status);
        super.save(ds);
    }

    @Override
    @Transactional
    public void delete(DistributionSchedule entity) {
        this.deleteJobFor(entity.getId());
        super.delete(entity);
    }

    @Override
    @Transactional
    public void delete(Serializable id) {
        this.deleteJobFor((Long)id);
        super.delete(id);
    }

    private ScheduleRule getScheduleRule(Date date) {
        ScheduleRule rule = new ScheduleRule();
        rule.setType(ScheduleRuleType.ON_DATE);
        rule.setStartDate(date);
        rule.setEndDate(date);
        ArrayList<ScheduleRuleParameter> scheduleRuleParams = new ArrayList<ScheduleRuleParameter>();
        rule.setParams(scheduleRuleParams);
        ScheduleRuleParameter ruleParamDate = new ScheduleRuleParameter();
        ruleParamDate.setOrder(1);
        ruleParamDate.setValue(dateFormat.format(date));
        scheduleRuleParams.add(ruleParamDate);
        ScheduleRuleParameter ruleParamTime = new ScheduleRuleParameter();
        ruleParamTime.setOrder(2);
        ruleParamTime.setValue(timeFormat.format(date));
        scheduleRuleParams.add(ruleParamTime);
        return rule;
    }

    private boolean isDifferent(ScheduleRule rule, Date date) {
        return !rule.getParam(1).getValue().equals(dateFormat.format(date)) || !rule.getParam(2).getValue().equals(timeFormat.format(date));
    }

    private void deleteJobFor(long id) {
        List jobs = this.getScheduler().getJobsByAssociatedEntity(ENTITY_TYPE, id);
        if (jobs != null && !jobs.isEmpty()) {
            this.getScheduler().delete(((Job)jobs.get(0)).getId().longValue());
        }
    }

    private IScheduler getScheduler() {
        return (IScheduler)InjectionUtil.injectInstance((String)"cms/Scheduler/local", IScheduler.class);
    }
}

