/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.schedule.notify.INotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import com.tandbergtv.watchpoint.pmm.schedule.notify.NotificationSetting;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractNotificationGenerator
implements INotificationGenerator {
    private String metadataFieldName;
    private String metadataFieldType;
    public static final String PROGRESS_UI_SETTINGS_GROUP = "com.ericsson.cms.pmm.progress";
    public static final String PROP_NOTIFICATION_GENERATION_INTERAL = "notification_generation_interval";
    public static final String PROP_FUTURE = "future";
    public static final String PROP_PAST = "past";
    public static final String PROP_PLANNER_STATUS_OFFSET = "planner_schedule_offset";
    public static final String PROP_PITCHER_STATUS_OFFSET = "pitch_schedule_offset";
    public static final String PROP_FIELD_NAME = "metadata_variable_xpath";
    public static final String PROP_FIELD_TYPE = "metadata_variable_type";
    private static final Logger logger = Logger.getLogger(AbstractNotificationGenerator.class);
    private IConfigurationService configurationService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);

    AbstractNotificationGenerator() {
        this.setTitleMetadataInfo();
    }

    @Transactional
    public Notification getNotification(Schedule schedule) {
        if (schedule.getTitles().isEmpty()) {
            return null;
        }
        int delta = this.getNoficiationOffset().offset;
        Date deadline = this.diff(schedule.getDate(), delta);
        logger.debug((Object)("Deadline " + deadline));
        if (deadline.after(this.getToday())) {
            logger.debug((Object)(schedule + ", is after cutoff date "));
            return null;
        }
        boolean warn = false;
        HashSet<Title> titles = new HashSet<Title>();
        Notification notification = null;
        for (Title title : schedule.getTitles()) {
            if (!this.isTitleDelayed(title)) continue;
            logger.debug((Object)("Adding notification for " + schedule + ", title " + title));
            if (notification == null) {
                notification = new Notification(schedule);
            }
            notification.addTitleId(title.getId());
            titles.add(title);
            warn = true;
        }
        if (warn) {
            this.addMessage(notification, titles);
        }
        return notification;
    }

    @Transactional
    protected String constructMessage(Collection<Title> titles) {
        String message = "";
        if (this.metadataFieldName == null || this.metadataFieldType == null) {
            return null;
        }
        for (Title title : titles) {
            String value;
            Field field = this.getMetadataField(title, this.metadataFieldType, this.metadataFieldName);
            String string = value = field != null ? field.getValue() : null;
            if (value == null || value.length() == 0) {
                value = title.getId().toString();
            }
            if (message.length() > 0) {
                message = message + ", ";
            }
            message = message + value;
        }
        return message;
    }

    private Field getMetadataField(Title title, String assetType, String fieldName) {
        List assets = title.getAssets(assetType);
        for (Asset asset : assets) {
            Field field = asset.getField(fieldName);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    protected abstract void addMessage(Notification var1, Collection<Title> var2);

    protected abstract String getType();

    protected Date getToday() {
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    protected Date diff(Date date, int days) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, days);
        return calendar.getTime();
    }

    protected abstract NotificationSetting getNoficiationOffset();

    protected void setTitleMetadataInfo() {
        Map<String, String> progSettings = this.getConfiguration();
        this.metadataFieldName = progSettings.get(PROP_FIELD_NAME);
        logger.debug((Object)("metadataFieldName " + this.metadataFieldName));
        this.metadataFieldType = progSettings.get(PROP_FIELD_TYPE);
        logger.debug((Object)("metadataFieldType " + this.metadataFieldType));
        if (this.metadataFieldName == null || this.metadataFieldType == null) {
            throw new ScheduleRuntimeException("Variable name and type must be specified.");
        }
    }

    protected Map<String, String> getConfiguration() {
        Map progressSettings = this.configurationService.getProperties(PROGRESS_UI_SETTINGS_GROUP);
        return progressSettings;
    }

    protected abstract boolean isTitleDelayed(Title var1);
}

