/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.ericsson.cms.sites.core.ISiteManager;
import com.ericsson.cms.sites.core.entities.DistributionSiteTitle;
import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.core.entities.Site;
import com.ericsson.cms.sites.core.entities.SiteType;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.schedule.notify.AbstractNotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import com.tandbergtv.watchpoint.pmm.schedule.notify.NotificationSetting;
import com.tandbergtv.watchpoint.pmm.schedule.notify.SlimSchedule;
import com.tandbergtv.watchpoint.pmm.util.LocalizedMessageUtil;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PitchNotificationGenerator
extends AbstractNotificationGenerator {
    private static LocalizedMessageUtil messageUtil = new LocalizedMessageUtil("partner");
    private ISiteManager siteManager = (ISiteManager)InjectionUtil.injectInstance((String)"cms/SiteManager/local", ISiteManager.class);
    private Site site;

    public PitchNotificationGenerator(Site site) {
        this.site = site;
    }

    @Override
    protected String getType() {
        return "pitch";
    }

    @Override
    protected NotificationSetting getNoficiationOffset() {
        Map<String, String> progSettings = this.getConfiguration();
        return new NotificationSetting(Integer.parseInt(progSettings.get("pitch_schedule_offset")));
    }

    @Override
    protected void addMessage(Notification notification, Collection<Title> titles) {
        String message = super.constructMessage(titles);
        SlimSchedule schedule = notification.getSchedule();
        String date = new SimpleDateFormat("yyyy-MM-dd").format(schedule.getDate());
        String msg = messageUtil.getMessageValue("warnTitlesNotDistributedSuccessfully", new Object[]{this.site.getName(), date, message});
        notification.addMessage(msg);
    }

    @Override
    protected boolean isTitleDelayed(Title title) {
        List distributeTitles = this.siteManager.getDistributionSiteTitles(title.getId().longValue());
        return !this.isSiteTitleDistributed(this.site, distributeTitles);
    }

    private boolean isSiteTitleDistributed(Site site, List<DistributionSiteTitle> distributeTitles) {
        boolean isDistributed = true;
        if (distributeTitles.isEmpty()) {
            return false;
        }
        if (SiteType.LOGICAL.equals((Object)site.getType())) {
            Site childSite;
            if (site.getSiteChildren().isEmpty()) {
                return false;
            }
            Iterator iterator = site.getSiteChildren().iterator();
            while (iterator.hasNext() && (isDistributed = this.isSiteTitleDistributed(childSite = (Site)iterator.next(), distributeTitles))) {
            }
        } else {
            for (DistributionSiteTitle siteTitles : distributeTitles) {
                if (!site.getId().equals(siteTitles.getDistributionSite().getId()) || DistributionStatus.DISTRIBUTED.equals((Object)siteTitles.getStatus())) continue;
                isDistributed = false;
                break;
            }
        }
        return isDistributed;
    }
}

