/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.AssetList;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class DefaultTitlePersistenceService
implements ITitlePersistenceService {
    private static final String PARAM_TITLE_ID = "titleID";
    private final ITTVDataModelHandler assetDataModelHandler;

    public DefaultTitlePersistenceService(ITTVDataModelHandler dataModelHandler) {
        this.assetDataModelHandler = dataModelHandler;
    }

    @Override
    @Deprecated
    @Transactional
    public void save(Title t) {
        try {
            boolean draft = TitleStatus.DRAFT.equals((Object)t.getStatus());
            Asset asset = this.getTTVDataModelHandler().saveAsset(t.getAsset(), draft);
            t.setAsset(asset);
            t.getAssetStatusMap().put(asset.getVersion(), t.getStatus());
        }
        catch (MetadataException e) {
            String msg = "Failed to save title, error: " + e.getMessage();
            String errorCode = "TPS-001";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)e);
            error.getParameters().add(e.getLocalizedMessage());
            throw error;
        }
        this.getCurrentSession().saveOrUpdate((Object)t);
    }

    @Override
    @Transactional
    public void save(Title t, boolean createAssetRevision) {
        if (createAssetRevision) {
            this.save(t);
        } else {
            this.updateRevisionDraft(t);
            this.getCurrentSession().saveOrUpdate((Object)t);
        }
    }

    private void updateRevisionDraft(Title t) {
        Asset asset = t.getAsset();
        int latestRevisionNum = asset.getLatestRevisionNumber();
        String queryStr = "update mdm_rootassetrevision set draft=:draft where id = (select id from mdm_rootassetrevision r where asset_id=:assetId and revisionnumber=:revisionNumber)";
        NativeQuery query = this.getCurrentSession().createSQLQuery(queryStr);
        query.setParameter("draft", (Object)(TitleStatus.DRAFT.equals((Object)t.getStatus()) ? 1 : 0));
        query.setParameter("assetId", (Object)asset.getId());
        query.setParameter("revisionNumber", (Object)latestRevisionNum);
        query.executeUpdate();
        t.getAssetStatusMap().put(t.getAsset().getVersion(), t.getStatus());
    }

    @Override
    @Transactional
    public void rollback(Title title, String revision) {
        try {
            boolean draft = TitleStatus.DRAFT.equals((Object)title.getStatus());
            TTVId ttvId = title.getAsset().getTTVId();
            ISpecHandler ttvHandler = this.getTTVSpecHandler();
            ttvHandler.rollBackToRevision(ttvId, revision);
            Asset rolledbackAsset = this.getTTVDataModelHandler().getAsset(ttvId);
            if (draft) {
                rolledbackAsset = this.getTTVDataModelHandler().saveAsset(rolledbackAsset, draft);
            }
            title.setAsset(rolledbackAsset);
            title.getAssetStatusMap().put(title.getAsset().getVersion(), title.getStatus());
        }
        catch (SearchException e) {
            String errorCode = "TPS-006";
            String msg = "Failed to find title[" + title.getId() + "] with revision: " + revision + " for roll back, error: " + e.getLocalizedMessage();
            throw this.buildRollbackError(title, revision, errorCode, msg, e);
        }
        catch (InvalidRevisionException e) {
            String errorCode = "TPS-005";
            String msg = "Failed to roll back title[" + title.getId() + "] to revision: " + revision + ", error: " + e.getLocalizedMessage();
            throw this.buildRollbackError(title, revision, errorCode, msg, e);
        }
        catch (MetadataException | TranslationException e) {
            String errorCode = "TPS-004";
            String msg = "Failed to roll back title[" + title.getId() + "] to revision: " + revision + ", error: " + e.getLocalizedMessage();
            throw this.buildRollbackError(title, revision, errorCode, msg, e);
        }
        this.getCurrentSession().saveOrUpdate((Object)title);
    }

    private TitlePersistenceException buildRollbackError(Title title, String version, String errorCode, String msg, Throwable e) {
        TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, e);
        error.getParameters().add(Long.toString(title.getId()));
        error.getParameters().add(version);
        error.getParameters().add(e.getLocalizedMessage());
        return error;
    }

    @Override
    @Transactional
    public Title get(Serializable id) {
        return this.loadTitle(id);
    }

    @Override
    @Transactional
    public Title get(Serializable id, boolean ignoreDraft) {
        if (!ignoreDraft) {
            return this.get(id);
        }
        int revision = this.getLastNonDraftRevision(id);
        if (revision > 0) {
            return this.get(id, String.valueOf(revision));
        }
        String msg = "Failed to get title[" + id + "], error: No revision found with commit/ready status";
        String errorCode = "TPS-008";
        TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, null);
        error.getParameters().add(String.valueOf(id));
        throw error;
    }

    @Override
    public Asset getAsset(Long assetId) {
        Asset asset = null;
        try {
            asset = this.getTTVDataModelHandler().getAsset(assetId);
        }
        catch (SearchException se) {
            String msg = "Failed to get asset[" + assetId + "], error: " + se.getMessage();
            String errorCode = "TPS-002";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)se);
            error.getParameters().add(se.getLocalizedMessage());
            throw error;
        }
        return asset;
    }

    @Override
    @Transactional
    public Title get(Serializable id, String version) {
        Title title = this.loadTitle(id);
        Title copy = new Title(title);
        TTVId ttvId = title.getAsset().getTTVId();
        try {
            Asset olderVersionAsset = this.getTTVDataModelHandler().getAsset(ttvId, version);
            copy.setAsset(olderVersionAsset);
        }
        catch (SearchException se) {
            String msg = "Failed to get title[" + id + ", version: " + version + "], error: " + se.getMessage();
            String errorCode = "TPS-002";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)se);
            error.getParameters().add(se.getLocalizedMessage());
            throw error;
        }
        return copy;
    }

    @Override
    @Transactional
    @Deprecated
    public Title getWithHistory(Serializable id) {
        return this.get(id);
    }

    private Title loadTitle(Serializable id) {
        Title title = null;
        try {
            title = (Title)this.getCurrentSession().load(Title.class, id);
        }
        catch (RuntimeException e) {
            String msg = "Failed to load title[" + id + "], error: " + e.getMessage();
            String errorCode = "TPS-007";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)e);
            error.getParameters().add(String.valueOf(id));
            error.getParameters().add(e.getLocalizedMessage());
            throw error;
        }
        return title;
    }

    @Override
    @Transactional
    public Title getTitleForUpdate(Serializable id) {
        Title t = (Title)this.getCurrentSession().load(Title.class, id, LockOptions.UPGRADE);
        this.getCurrentSession().refresh((Object)t);
        return t;
    }

    @Override
    @Transactional
    public synchronized boolean delete(Serializable id) {
        Session session = this.getCurrentSession();
        Title title = (Title)session.get(Title.class, id);
        if (title == null) {
            return false;
        }
        try {
            this.getTTVDataModelHandler().delete(title.getAsset());
        }
        catch (SearchException e) {
            String msg = "Failed to delete title[" + id + "], error: " + e.getMessage();
            String errorCode = "TPS-002";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg, (Throwable)e);
            error.getParameters().add(e.getLocalizedMessage());
            throw error;
        }
        title.setStatus(TitleStatus.DELETED);
        title.setLastModifiedTime(new Date());
        title.setIsActive(Boolean.valueOf(false));
        Collection lists = title.getTitlelists();
        for (IAssetList list : lists) {
            AssetList clone = (AssetList)session.load(AssetList.class, (Serializable)list.getId());
            clone.removeTitle(title);
            session.saveOrUpdate((Object)clone);
        }
        for (ProgressItem item : title.getProgressItems()) {
            item.setIsActive(Boolean.valueOf(false));
        }
        session.saveOrUpdate((Object)title);
        return true;
    }

    @Override
    @Transactional
    public Title retire(Title title) {
        this.save(title, false);
        return title;
    }

    @Override
    @Transactional
    public boolean isActiveTitle(Serializable id) {
        Query query = this.getCurrentSession().getNamedQuery("Title.GetAssetState");
        query.setParameter(PARAM_TITLE_ID, (Object)id);
        Object result = query.uniqueResult();
        return result != null && !TitleStatus.DELETED.equals(result);
    }

    @Override
    @Transactional
    public boolean isExistingTitle(Serializable id) {
        if (id == null) {
            return false;
        }
        Query query = this.getCurrentSession().getNamedQuery("Title.IsExistingTitle");
        query.setParameter(PARAM_TITLE_ID, (Object)id);
        Long result = (Long)query.uniqueResult();
        return result != 0L;
    }

    @Override
    @Transactional
    public Collection<Long> getCopyIds(Serializable id) {
        Query query = this.getCurrentSession().getNamedQuery("Title.GetCopyIDs");
        query.setParameter("originalTitleID", (Object)id);
        return query.list();
    }

    @Override
    @Transactional
    public Long getOriginalId(Serializable id) {
        Query query = this.getCurrentSession().getNamedQuery("Title.GetOriginalID");
        query.setParameter("copyTitleID", (Object)id);
        return (Long)query.uniqueResult();
    }

    @Override
    @Transactional
    public Long getIdByAssetId(long assetId) {
        Query query = this.getCurrentSession().getNamedQuery("Title.GetIDByRootAssetID");
        query.setParameter("rootAssetID", (Object)assetId);
        return (Long)query.uniqueResult();
    }

    @Override
    @Transactional
    public Long getPartnerId(Serializable id) {
        Query query = this.getCurrentSession().getNamedQuery("Title.GetPartnerID");
        query.setParameter(PARAM_TITLE_ID, (Object)id);
        return (Long)query.uniqueResult();
    }

    @Override
    @Transactional
    public Map<String, String> getSiteDistributionStatusMap(Serializable id) {
        String queryStr = "SELECT dst.titleid as siteTitleId, dst.status as distributionStatus FROM PMM_TITLE title JOIN SITES_DISTSITETITLE dst ON (dst.titleid = title.id_) WHERE title.ORIGINALTITLE_ID = :originalTitleID AND title.TITLESTATUSID <> 5";
        NativeQuery query = this.getCurrentSession().createSQLQuery(queryStr).addScalar("siteTitleId", (Type)StandardBasicTypes.STRING).addScalar("distributionStatus", (Type)StandardBasicTypes.INTEGER);
        query.setParameter("originalTitleID", (Object)id);
        List rows = query.list();
        HashMap<String, String> siteDistributionStatusMap = new HashMap<String, String>(rows.size());
        for (Object[] row : rows) {
            siteDistributionStatusMap.put(row[0].toString(), DistributionStatus.values()[(Integer)row[1]].toString());
        }
        return siteDistributionStatusMap;
    }

    @Transactional
    private int getLastNonDraftRevision(Serializable titleId) {
        String queryStr = "select max(revisionnumber) from mdm_rootassetrevision r join pmm_title t on (r.asset_id=t.mdmdocid) where t.id_=:titleId and draft=0";
        NativeQuery query = this.getCurrentSession().createSQLQuery(queryStr);
        query.setParameter("titleId", (Object)titleId);
        Number result = (Number)query.uniqueResult();
        return result != null ? result.intValue() : 0;
    }

    public String getServiceName() {
        return "Title Persistence";
    }

    public void start() {
    }

    public void stop() {
    }

    private Session getCurrentSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    private ITTVDataModelHandler getTTVDataModelHandler() {
        return this.assetDataModelHandler;
    }

    private ISpecHandler getTTVSpecHandler() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        ISpecificationManager manager = (ISpecificationManager)registry.lookup(ISpecificationManager.class);
        return manager.getInternalSpecification().getSpecHandler();
    }

    @Override
    @Transactional
    public List<Long> getByUsername(String username) {
        Query query = this.getCurrentSession().getNamedQuery("Title.GetByUsername");
        query.setParameter("username", (Object)username);
        return query.list();
    }

    @Override
    @Transactional
    public boolean isOriginalTitle(Serializable id) {
        if (id == null) {
            return false;
        }
        Query query = this.getCurrentSession().getNamedQuery("Title.isOriginal");
        query.setParameter("titleId", (Object)id);
        Long result = (Long)query.uniqueResult();
        return result != 0L;
    }
}

