/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.LicenseAuditTrail;
import com.tandbergtv.watchpoint.pmm.entities.LicenseUsageAudit;
import com.tandbergtv.watchpoint.pmm.title.ILicenseUsageAudit;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.LicenseMonitor;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class LicenseAuditUsage
implements ILicenseUsageAudit,
MembershipListener {
    private static final Logger logger = Logger.getLogger(LicenseAuditUsage.class);
    private static final String LICENSE_TYPE_MASTER = "MASTER TITLES";
    private static final String LICENSE_TYPE_TOKEN = "TOKENS";
    private static final String KEY = "F!FAF3VR";
    private static final String UI_PREFERENCE_PATH = "com.ericsson.cms.usagemonitor";
    private ISchedulerService<Void> scheduler;
    private IClusterService clusterService;
    private LicenseMonitor licenseMonitor;
    private IConfigurationService configurationService;

    public String getServiceName() {
        return "licenseAuditUsage";
    }

    public void start() {
        this.getClusterService().getInstance().getCluster().addMembershipListener((MembershipListener)this);
        if (this.getClusterService().isMaster()) {
            this.activate();
        }
    }

    private void activate() {
        this.scheduler = new Scheduler("LicenseMonitor", 1, 1);
        this.scheduler.start();
        this.scheduler.schedule(() -> {
            try {
                this.setAuditTrail();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }, (long)this.getRefreshTimer().intValue(), (long)this.getScheduleTimer().intValue());
    }

    protected void setAuditTrail() {
        this.audit(LICENSE_TYPE_MASTER, String.valueOf(this.getLicenseMonitor().getMasterTitleCount()));
        this.audit(LICENSE_TYPE_TOKEN, String.valueOf(this.getLicenseMonitor().getTokenUsage()));
    }

    private void audit(String type, String usage) {
        LicenseUsageAudit property = new LicenseUsageAudit();
        LicenseAuditTrail auditTrail = new LicenseAuditTrail();
        Date createDate = Calendar.getInstance().getTime();
        property.setCreateDate(createDate);
        property.setType(type);
        property.setUsage(LicenseAuditUsage.encrypt(usage));
        auditTrail.setType(type);
        auditTrail.setHash(this.encryptSha1(usage + '-' + createDate.getTime()));
        this.saveAuditTrail(auditTrail);
        this.saveAudit(property);
    }

    private String encryptSha1(String source) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(source.getBytes("UTF-8"));
            return DatatypeConverter.printBase64Binary((byte[])digest.digest());
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    private static String encrypt(String inputString) {
        try {
            DESKeySpec dks = new DESKeySpec(KEY.getBytes());
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
            SecretKey desKey = skf.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, desKey);
            byte[] textEncrypted = cipher.doFinal(inputString.getBytes());
            return DatatypeConverter.printBase64Binary((byte[])textEncrypted);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public void stop() {
    }

    @Override
    @Transactional
    public void saveAudit(LicenseUsageAudit property) {
        Session session = HibernateContext.getContext().getCurrentSession();
        session.saveOrUpdate((Object)property);
    }

    @Override
    @Transactional
    public void saveAuditTrail(LicenseAuditTrail property) {
        Session session = HibernateContext.getContext().getCurrentSession();
        session.saveOrUpdate((Object)property);
    }

    public void memberAdded(MembershipEvent membershipEvent) {
    }

    public void memberRemoved(MembershipEvent membershipEvent) {
        if (this.getClusterService().isMaster()) {
            this.activate();
        }
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    public IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
        }
        return this.clusterService;
    }

    private LicenseMonitor getLicenseMonitor() {
        if (this.licenseMonitor == null) {
            this.licenseMonitor = LicenseMonitor.getInstance();
        }
        return this.licenseMonitor;
    }

    private IConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        }
        return this.configurationService;
    }

    private Integer getScheduleTimer() {
        return Integer.valueOf((String)this.getConfigurationService().getProperties(UI_PREFERENCE_PATH).get("cms.usagemonitor.auditTime"));
    }

    private Integer getRefreshTimer() {
        return Integer.valueOf((String)this.getConfigurationService().getProperties(UI_PREFERENCE_PATH).get("cms.usagemonitor.refreshTime"));
    }
}

