/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetProperty;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetPropertyManager;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class TitleAssetPropertyManager
implements ITitleAssetPropertyManager {
    @Override
    @Transactional
    public boolean delete(long id) {
        Session session = HibernateContext.getContext().getCurrentSession();
        TitleAssetProperty property = (TitleAssetProperty)session.get(TitleAssetProperty.class, (Serializable)Long.valueOf(id));
        if (property != null) {
            session.delete((Object)property);
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public void deleteByTitle(long titleId) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.createQuery("select tap from TitleAssetProperty as tap where tap.titleId = :titleid");
        query.setParameter("titleid", (Object)titleId);
        List list = query.list();
        for (TitleAssetProperty asset : list) {
            session.delete((Object)asset);
        }
    }

    @Override
    @Transactional
    public void deleteByTitleAsset(long titleId, long assetId) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.createQuery("select tap from TitleAssetProperty as tap where tap.titleId = :titleid and tap.assetId = :assetid");
        query.setParameter("titleid", (Object)titleId);
        query.setParameter("assetid", (Object)assetId);
        List list = query.list();
        for (TitleAssetProperty asset : list) {
            session.delete((Object)asset);
        }
    }

    @Override
    @Transactional
    public TitleAssetProperty get(long id) {
        Session session = HibernateContext.getContext().getCurrentSession();
        TitleAssetProperty property = (TitleAssetProperty)session.load(TitleAssetProperty.class, (Serializable)Long.valueOf(id));
        return property;
    }

    @Override
    @Transactional
    public List<TitleAssetProperty> getByTitle(long titleId) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.createQuery("select tap from TitleAssetProperty as tap where tap.titleId = :titleid");
        query.setParameter("titleid", (Object)titleId);
        List propertyList = query.list();
        return propertyList;
    }

    @Override
    @Transactional
    public List<TitleAssetProperty> getByTitleAsset(long titleId, String name) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.createQuery("select tap from TitleAssetProperty as tap where tap.titleId = :titleid and tap.name = :name");
        query.setParameter("titleid", (Object)titleId);
        query.setParameter("name", (Object)name);
        List propertyList = query.list();
        return propertyList;
    }

    @Override
    @Transactional
    public List<TitleAssetProperty> getByTitleAsset(long titleId, long assetId) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.createQuery("select tap from TitleAssetProperty as tap where tap.titleId = :titleid and tap.assetId = :assetid");
        query.setParameter("titleid", (Object)titleId);
        query.setParameter("assetid", (Object)assetId);
        List propertyList = query.list();
        return propertyList;
    }

    @Override
    @Transactional
    public List<TitleAssetProperty> getByTitleAsset(long titleId, long assetId, String name) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.createQuery("select tap from TitleAssetProperty as tap where tap.titleId = :titleid and tap.assetId = :assetid and tap.name = :name ORDER BY tap.updateDate DESC");
        query.setParameter("titleid", (Object)titleId);
        query.setParameter("assetid", (Object)assetId);
        query.setParameter("name", (Object)name);
        List propertyList = query.list();
        return propertyList;
    }

    @Override
    @Transactional
    public TitleAssetProperty save(TitleAssetProperty property) {
        Session session = HibernateContext.getContext().getCurrentSession();
        session.saveOrUpdate((Object)property);
        return property;
    }

    public String getServiceName() {
        return "TitleAssetPropertyManager";
    }

    public void start() {
    }

    public void stop() {
    }
}

