/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetProperty;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetResource;
import com.tandbergtv.watchpoint.pmm.entities.TitleResource;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleResourceManager;
import com.tandbergtv.watchpoint.pmm.title.TitleAssetPropertyManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class TitleAssetResourceManager
implements ITitleAssetResourceManager {
    private static final String KEY_FRAMES = "KEY_FRAMES";
    private static final String STILL_IMAGE = "STILL_IMAGE";
    private static final String THUMBNAIL = "THUMBNAIL";
    private static final String THUMBNAIL_LARGE_SUFFIX = "large";
    private static final String THUMBNAIL_MEDIUM_SUFFIX = "medium";
    private HazelcastInstance haz;
    private static final Logger logger = Logger.getLogger(TitleAssetResourceManager.class);

    protected HazelcastInstance getHazelcastInstance() {
        if (this.haz == null) {
            this.haz = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH).getInstance();
        }
        return this.haz;
    }

    private TitleAssetPropertyManager getService() {
        return (TitleAssetPropertyManager)ServiceRegistry.getDefault().lookup(TitleAssetPropertyManager.class);
    }

    private ITitleResourceManager getTitleResourceManager() {
        return (ITitleResourceManager)ServiceRegistry.getDefault().lookup(ITitleResourceManager.class);
    }

    private TitleAssetResource propertyToResource(TitleAssetProperty property) {
        if (property == null) {
            return null;
        }
        TitleAssetResource resource = new TitleAssetResource();
        resource.setResourcePath(property.getValue());
        resource.setAssetId(property.getAssetId().longValue());
        resource.setTitleId(property.getTitleId().longValue());
        if (THUMBNAIL.equals(property.getName())) {
            resource.setResourceType(TitleAssetResource.ResourceType.THUMBNAIL);
        } else if (STILL_IMAGE.equals(property.getName())) {
            resource.setResourceType(TitleAssetResource.ResourceType.STILL_IMAGE);
        } else if (KEY_FRAMES.equals(property.getName())) {
            resource.setResourceType(TitleAssetResource.ResourceType.KEY_FRAMES);
        }
        resource.setCreateDate(property.getUpdateDate());
        return resource;
    }

    private List<TitleAssetResource> propertyListToResourceList(List<TitleAssetProperty> propertyList) {
        ArrayList<TitleAssetResource> resourceList = new ArrayList<TitleAssetResource>();
        for (TitleAssetProperty property : propertyList) {
            TitleAssetResource resource = this.propertyToResource(property);
            resourceList.add(resource);
        }
        return resourceList;
    }

    @Transactional
    public TitleAssetResource getKeyFrames(long titleId, long assetId) {
        List<TitleAssetProperty> list = this.getService().getByTitleAsset(titleId, assetId, KEY_FRAMES);
        if (list == null || list.isEmpty()) {
            return null;
        }
        TitleAssetProperty property = list.get(0);
        return this.propertyToResource(property);
    }

    @Transactional
    public List<TitleAssetResource> getKeyFrames(long titleId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, KEY_FRAMES);
        return this.propertyListToResourceList(propertyList);
    }

    @Transactional
    public List<TitleAssetResource> getStillImages(long titleId, long assetId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, assetId, STILL_IMAGE);
        return this.propertyListToResourceList(propertyList);
    }

    @Transactional
    public List<TitleAssetResource> getStillImages(long titleId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, STILL_IMAGE);
        return this.propertyListToResourceList(propertyList);
    }

    @Transactional
    public TitleAssetResource getThumbnail(long titleId, long assetId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, assetId, THUMBNAIL);
        List<TitleAssetProperty> filterPropertyList = this.getFilteredThumbnails(propertyList);
        if (filterPropertyList == null || propertyList.isEmpty()) {
            return null;
        }
        return this.propertyToResource(filterPropertyList.get(0));
    }

    @Transactional
    public List<TitleAssetResource> getThumbnails(long titleId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, THUMBNAIL);
        List<TitleAssetProperty> filterPropertyList = this.getFilteredThumbnails(propertyList);
        if (filterPropertyList == null || filterPropertyList.isEmpty()) {
            return null;
        }
        return this.propertyListToResourceList(filterPropertyList);
    }

    private List<TitleAssetProperty> getFilteredThumbnails(List<TitleAssetProperty> propertyList) {
        if (propertyList == null || propertyList.isEmpty()) {
            return null;
        }
        ArrayList<TitleAssetProperty> filterPropertyList = new ArrayList<TitleAssetProperty>();
        for (TitleAssetProperty property : propertyList) {
            String resourcePath = property.getValue();
            if (resourcePath.toLowerCase().contains(THUMBNAIL_LARGE_SUFFIX) || resourcePath.toLowerCase().contains(THUMBNAIL_MEDIUM_SUFFIX)) continue;
            filterPropertyList.add(property);
        }
        return filterPropertyList;
    }

    @Transactional
    public void registerKeyFrames(long titleId, long assetId, String assetType, String keyFramesPath) {
        TitleAssetProperty property;
        this.getTitleResourceManager().save(new TitleResource(titleId, keyFramesPath));
        List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId, KEY_FRAMES);
        if (properties == null || properties.isEmpty()) {
            property = new TitleAssetProperty();
            property.setAssetId(Long.valueOf(assetId));
            property.setName(KEY_FRAMES);
            property.setTitleId(Long.valueOf(titleId));
            if (assetType != null) {
                property.setValue(assetType);
            }
            property.setValue(keyFramesPath);
            property.setUpdateDate(new Date());
        } else {
            property = properties.get(0);
            property.setValue(keyFramesPath);
            property.setUpdateDate(new Date());
        }
        this.getService().save(property);
    }

    @Transactional
    public void registerStillImage(long titleId, long assetId, String assetType, String imagePath) {
        TitleAssetProperty property;
        this.getTitleResourceManager().save(new TitleResource(titleId, imagePath));
        List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId, STILL_IMAGE);
        boolean save = true;
        for (TitleAssetProperty property2 : properties) {
            if (imagePath == null || !imagePath.equals(property2.getValue())) continue;
            save = false;
        }
        if (save) {
            property = new TitleAssetProperty();
            property.setAssetId(Long.valueOf(assetId));
            property.setName(STILL_IMAGE);
            property.setTitleId(Long.valueOf(titleId));
            property.setValue(imagePath);
            if (assetType != null) {
                property.setValue(assetType);
            }
        } else {
            throw new RuntimeException("Still Image with titleId: " + titleId + " , assetId: " + assetId + ", and value: " + imagePath + " already registered in the database");
        }
        property.setUpdateDate(new Date());
        this.getService().save(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void registerThumbnail(long titleId, long assetId, String assetType, String thumbnailPath) {
        ILock lock = this.getRegisterThumbnailLock(titleId, assetId, THUMBNAIL, thumbnailPath);
        try {
            lock.lock();
            logger.debug((Object)(lock.getPartitionKey() + " is starting to lock"));
            this.getTitleResourceManager().save(new TitleResource(titleId, thumbnailPath));
            TitleAssetProperty property = null;
            List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId, THUMBNAIL);
            if (properties != null && !properties.isEmpty()) {
                for (TitleAssetProperty p : properties) {
                    if (!p.getTitleId().equals(titleId) || !p.getAssetId().equals(assetId) || !p.getAssetType().equalsIgnoreCase(assetType) || !p.getValue().equalsIgnoreCase(thumbnailPath)) continue;
                    property = p;
                    property.setUpdateDate(new Date());
                    break;
                }
            }
            if (property == null) {
                property = new TitleAssetProperty();
                property.setAssetId(Long.valueOf(assetId));
                property.setAssetType(assetType);
                property.setName(THUMBNAIL);
                property.setTitleId(Long.valueOf(titleId));
                property.setValue(thumbnailPath);
                property.setUpdateDate(new Date());
            }
            this.getService().save(property);
        }
        finally {
            lock.unlock();
            logger.debug((Object)(lock.getPartitionKey() + " is unlocked."));
        }
    }

    protected ILock getRegisterThumbnailLock(long titleId, long assetId, String name, String value) {
        return this.getHazelcastInstance().getLock("registerThumbnailLock_" + titleId + "_" + assetId + "_" + name + "_" + value);
    }

    @Transactional
    public void unregisterKeyFrames(long titleId, long assetId) {
        List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!KEY_FRAMES.equals(property.getName())) continue;
            this.getService().delete(property.getId());
        }
    }

    @Transactional
    public void unregisterResourcesForTitle(long titleId) {
        List<TitleAssetProperty> properties = this.getService().getByTitle(titleId);
        for (TitleAssetProperty property : properties) {
            if (KEY_FRAMES.equals(property.getName())) {
                this.getService().delete(property.getId());
                continue;
            }
            if (THUMBNAIL.equals(property.getName())) {
                this.getService().delete(property.getId());
                continue;
            }
            if (!STILL_IMAGE.equals(property.getName())) continue;
            this.getService().delete(property.getId());
        }
    }

    @Transactional
    public void unregisterStillImages(long titleId, long assetId, String imagePath) {
        List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!STILL_IMAGE.equals(property.getName()) || !property.getValue().equals(imagePath)) continue;
            this.getService().delete(property.getId());
        }
    }

    @Transactional
    public void unregisterStillImages(long titleId, long assetId) {
        List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!STILL_IMAGE.equals(property.getName())) continue;
            this.getService().delete(property.getId());
        }
    }

    @Transactional
    public void unregisterThumbnail(long titleId, long assetId) {
        List<TitleAssetProperty> properties = this.getService().getByTitleAsset(titleId, assetId);
        for (TitleAssetProperty property : properties) {
            if (!THUMBNAIL.equals(property.getName())) continue;
            this.getService().delete(property.getId());
        }
    }

    public String getServiceName() {
        return "TitleAssetResourceManager";
    }

    public void start() {
    }

    public void stop() {
    }

    public List<TitleAssetResource> getUnfilterThumbnailList(long titleId, long assetId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, assetId, THUMBNAIL);
        return this.propertyListToResourceList(propertyList);
    }

    public List<TitleAssetResource> getUnfilterThumbnailList(long titleId) {
        List<TitleAssetProperty> propertyList = this.getService().getByTitleAsset(titleId, THUMBNAIL);
        return this.propertyListToResourceList(propertyList);
    }
}

