/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.Binder;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleDocumentManager;
import com.tandbergtv.watchpoint.pmm.title.TitleDocumentActionException;
import com.tandbergtv.watchpoint.pmm.title.TitleManager;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public class TitleDocumentManager
implements ITitleDocumentManager {
    private final TitleManager titleManager;

    public TitleDocumentManager(TitleManager titleManager) {
        this.titleManager = titleManager;
    }

    @Transactional
    public Document getDocument(Title title, Specification specification) throws TitleDocumentActionException {
        try {
            ISpecHandler specHandler = specification.getSpecHandler();
            return specHandler.convertAssetToXMLDocument(title.getAsset());
        }
        catch (TranslationException te) {
            TitleDocumentActionException e = new TitleDocumentActionException("TDM-001", (Throwable)te);
            e.getParameters().add(te.getLocalizedMessage());
            throw e;
        }
    }

    public Document getDocument(Title title) {
        return this.getTTVDocument(title);
    }

    public Document getTTVDocument(Title title) {
        if (title == null) {
            throw new IllegalArgumentException("title can't be null");
        }
        Binder ttvXMLBinder = new Binder();
        return ttvXMLBinder.bind(title.getAsset());
    }

    public Document getECMFDocument(Title title) throws TitleDocumentActionException {
        if (title == null) {
            throw new IllegalArgumentException("title can't be null");
        }
        Specification internalSpecification = this.getSpecificationManager().getInternalSpecification();
        ISpecHandler specHandler = internalSpecification.getSpecHandler();
        Document result = null;
        try {
            result = specHandler.convertAssetToXMLDocument(title.getAsset());
        }
        catch (TranslationException e) {
            String msg = "Failed to convert title[" + title.getId() + "] to the internal specification metadata document, error: " + e.getLocalizedMessage();
            this.raiseDocumentActionException("TDM-001", msg, e);
        }
        return result;
    }

    @Transactional
    public Title getTitle(Document document) throws TitleDocumentActionException {
        Asset rootAsset;
        Long titleId;
        Specification internalSpecification = this.getSpecificationManager().getInternalSpecification();
        if (!internalSpecification.isSpecificationDocument(document)) {
            String msg = "The metadata document must be in the internal specification format.";
            this.raiseDocumentActionException("TDM-001", msg, null);
        }
        Title result = (titleId = this.titleManager.getIDByAssetID((rootAsset = this.getAssetForDocument(document, internalSpecification)).getId())) != null ? this.titleManager.get(titleId) : new Title();
        result.setAsset(rootAsset);
        return result;
    }

    private Asset getAssetForDocument(Document document, Specification specification) throws TitleDocumentActionException {
        Asset rootAsset;
        String msg;
        document.setStrictErrorChecking(false);
        ISpecHandler specHandler = specification.getSpecHandler();
        List assets = null;
        try {
            assets = specHandler.mergeWithoutSave(document);
        }
        catch (MetadataException e) {
            msg = "Failed to convert document into a title: " + e.getLocalizedMessage();
            this.raiseDocumentActionException("TDM-001", msg, e);
        }
        if (assets.size() != 1) {
            String msg2 = "The metadata document should contain only 1 root asset, found " + assets.size();
            this.raiseDocumentActionException("TDM-001", msg2, null);
        }
        if ((rootAsset = (Asset)assets.get(0)) == null) {
            msg = "The root asset found in the metadata document is null.";
            this.raiseDocumentActionException("TDM-001", msg, null);
        }
        return rootAsset;
    }

    @Transactional
    public List<Long> getTitleIDs(Document document) throws TitleDocumentActionException {
        ArrayList<Long> result = new ArrayList<Long>();
        ISpecificationManager manager = this.getSpecificationManager();
        ISpecHandler handler = manager.isInternalSpecificationDocument(document) ? manager.getInternalSpecification().getSpecHandler() : this.getSpecHandler(document);
        if (handler == null) {
            String msg = "Failed to identify the specification for metadata document. Check your license or the specification plugin(s).";
            this.raiseDocumentActionException("TDM-002", msg, null);
        }
        try {
            for (IIdentifier id : handler.getIdentifiers(document)) {
                result.add(this.getTitleID(id));
            }
        }
        catch (MetadataException e) {
            String msg = "Failed to get the root asset identifiers from the metadata document in specification[" + handler.getSpecName() + "]: " + e.getLocalizedMessage();
            this.raiseDocumentActionException("TDM-002", msg, e);
        }
        return result;
    }

    private ISpecHandler getSpecHandler(Document document) {
        ISpecificationManager specificationManager = this.getSpecificationManager();
        Specification specification = specificationManager.getSpecificationForDocument(document);
        return specification != null ? specification.getSpecHandler() : null;
    }

    private Long getTitleID(IIdentifier id) {
        try {
            if (id == null || !id.isValidIdentifier()) {
                return null;
            }
            TTVId ttvId = id.getAssetTTVId();
            return ttvId != null ? this.titleManager.getIDByAssetID(ttvId.getId()) : null;
        }
        catch (SearchException e) {
            return null;
        }
    }

    private ISpecificationManager getSpecificationManager() {
        return (ISpecificationManager)ServiceRegistry.getDefault().lookup(ISpecificationManager.class);
    }

    private void raiseDocumentActionException(String code, String message, Throwable cause) throws TitleDocumentActionException {
        TitleDocumentActionException error = new TitleDocumentActionException(code, message, cause);
        error.getParameters().add(message);
        throw error;
    }
}

