/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.ericsson.cms.criteria.ExpNode;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.title.search.ITitleSearchPersistenceService;
import com.tandbergtv.cms.title.search.entities.TitleSearch;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.usermgmt.service.IUserActionCallback;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.title.TitleSearchNotFoundException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class TitleSearchPersistenceService
implements ITitleSearchPersistenceService,
IUserActionCallback {
    private static final Logger logger = Logger.getLogger(TitleSearchPersistenceService.class);

    private Session getCurrentSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    @Transactional
    public void deleteTitleSearch(Serializable titleSearchId) {
        try {
            TitleSearch titleSearch = this.getTitleSearch(titleSearchId);
            this.getCurrentSession().delete((Object)titleSearch);
        }
        catch (TitleSearchNotFoundException e) {
            logger.warn((Object)"Not deleting something that isn't there.", (Throwable)e);
        }
    }

    @Transactional
    public void deleteTitleSearches(Set<Integer> titleSearchIds) {
        for (Integer titleSearchId : titleSearchIds) {
            this.deleteTitleSearch(titleSearchId);
        }
    }

    @Transactional
    public TitleSearch getTitleSearch(Serializable titleSearchId) throws TitleSearchNotFoundException {
        TitleSearch result = (TitleSearch)this.getCurrentSession().get(TitleSearch.class, titleSearchId);
        if (result == null) {
            String msg = "Wow this is embarassing but I cound't find the title search you asked for. TitleSearchId" + titleSearchId.toString();
            throw new TitleSearchNotFoundException(msg);
        }
        return result;
    }

    @Transactional
    public List<TitleSearch> getTitleSearchByUserName(String userName, boolean getAllVisibleToUser, CriteriaMode criteriaMode, int offset, int count) {
        String modeCond = "";
        if (criteriaMode != null) {
            modeCond = "and ts.filter.criteriaMode = " + criteriaMode.getIntValue();
        }
        String queryStr = getAllVisibleToUser ? "SELECT \tts FROM\t\tTitleSearch ts WHERE\t(userName = :userName OR shared = 1) " + modeCond + "ORDER BY ts.name" : "SELECT \tts FROM\t\tTitleSearch ts WHERE\tuserName = :userName " + modeCond + "ORDER BY ts.name";
        Query query = this.getCurrentSession().createQuery(queryStr);
        query.setParameter("userName", (Object)userName);
        if (count != 0) {
            query.setMaxResults(count);
            query.setFirstResult(offset);
        }
        return query.list();
    }

    @Transactional
    public void saveTitleSearch(TitleSearch titleSearch) {
        this.getCurrentSession().saveOrUpdate((Object)titleSearch);
    }

    @Transactional
    public void deleteExpNode(ExpNode expNode) {
        this.getCurrentSession().delete((Object)expNode);
    }

    public String getServiceName() {
        return "Title Search Persistence";
    }

    public void start() {
    }

    public void stop() {
    }

    @Transactional
    public void onBeforeDelete(User user) {
        logger.debug((Object)("Deleting " + user.getUserName() + "'s saved seaches."));
        try {
            List<TitleSearch> searches = this.getTitleSearchByUserName(user.getUserName(), false, null, 0, 0);
            for (TitleSearch ts : searches) {
                this.getCurrentSession().delete((Object)ts);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to delete user's saved searches. ", (Throwable)e);
        }
    }

    public void onCreate(User arg0) {
    }

    public void onDelete(User arg0) {
    }

    public void onUpdate(User arg0) {
    }
}

