/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.cms.portal.util.transaction.TransactionalRegister;
import com.tandbergtv.content.image.GenerateThumbnailResult;
import com.tandbergtv.content.image.IThumbnailGenerator;
import com.tandbergtv.content.image.ThumbnailGeneratorFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleAssetResource;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetResourceManager;
import com.tandbergtv.watchpoint.pmm.title.conf.IAssetTypesConfigurationService;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class TitleThumbnailHandler {
    private static final String THUMBNAIL_FOLDER = "thumbnails";
    private static final Logger logger = Logger.getLogger(TitleThumbnailHandler.class);
    private ThumbnailGeneratorFactory thumbnailGeneratorFactory;
    private IThumbnailGenerator thumbnailGenerator;

    public void updateThumbnails(Title title, Title oldTitle) {
        logger.info((Object)("start to update thumbnail for title " + title.getId()));
        ITitleAssetResourceManager resourceManager = this.getService(ITitleAssetResourceManager.class);
        List thumbnails = resourceManager.getThumbnails(title.getId().longValue());
        HashMap<Long, TitleAssetResource> thumbnailMap = new HashMap<Long, TitleAssetResource>();
        if (!CollectionUtils.isEmpty((Collection)thumbnails)) {
            for (TitleAssetResource thumbnailResource : thumbnails) {
                thumbnailMap.put(thumbnailResource.getAssetId(), thumbnailResource);
            }
        }
        Collection assets = title.getAllAssets(false);
        logger.info((Object)("get title [" + title.getId() + "] all assets: " + assets.stream().map(Asset::getId).collect(Collectors.toList())));
        List<GenerateThumbnailResult> thumbnailResults = this.determineNeedGenerateThumbnailAssets(assets, oldTitle, thumbnailMap);
        List generatedThumbnailResults = thumbnailResults.stream().filter(GenerateThumbnailResult::isGenerated).collect(Collectors.toList());
        List<GenerateThumbnailResult> unGeneratedThumbnailResults = thumbnailResults.stream().filter(result -> !result.isGenerated()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(unGeneratedThumbnailResults)) {
            this.generateThumbnails(title, unGeneratedThumbnailResults, resourceManager);
            generatedThumbnailResults.addAll(unGeneratedThumbnailResults);
        }
        for (GenerateThumbnailResult result2 : generatedThumbnailResults) {
            thumbnailMap.remove(result2.getAsset().getId());
        }
        for (TitleAssetResource resource : thumbnailMap.values()) {
            resourceManager.unregisterThumbnail(resource.getTitleId(), resource.getAssetId());
        }
    }

    private List<GenerateThumbnailResult> determineNeedGenerateThumbnailAssets(Collection<Asset> assets, Title titleBeforeSave, Map<Long, TitleAssetResource> thumbnailMap) {
        IAssetTypesConfigurationService service = this.getService(IAssetTypesConfigurationService.class);
        List imageAssetTypes = service.getThumbnailAssetTypes();
        ArrayList<GenerateThumbnailResult> generateThumbnailResults = new ArrayList<GenerateThumbnailResult>();
        for (Asset asset : assets) {
            String srcUrl;
            com.tandbergtv.metadatamanager.model.File originalFile = this.checkOrignalFile(imageAssetTypes, asset);
            if (originalFile == null) continue;
            String path = originalFile.getURL();
            if (titleBeforeSave != null) {
                boolean hasThumbnail;
                Asset matchingAsset = titleBeforeSave.getAsset(asset.getId());
                com.tandbergtv.metadatamanager.model.File oldFile = this.getOriginalFile(matchingAsset);
                boolean bl = hasThumbnail = thumbnailMap.get(asset.getId()) != null;
                if (oldFile != null && path.equals(oldFile.getURL()) && hasThumbnail && originalFile.getSize().equals(oldFile.getSize())) {
                    generateThumbnailResults.add(new GenerateThumbnailResult(asset, true));
                    continue;
                }
            }
            path = (srcUrl = AssetsManager.getThreadLocalInstance().getSourceFile(path)) != null ? srcUrl : path;
            generateThumbnailResults.add(new GenerateThumbnailResult(asset, path));
        }
        return generateThumbnailResults;
    }

    private com.tandbergtv.metadatamanager.model.File checkOrignalFile(List<String> imageAssetTypes, Asset asset) {
        if (!imageAssetTypes.contains(asset.getAssetType())) {
            return null;
        }
        com.tandbergtv.metadatamanager.model.File originalFile = this.getOriginalFile(asset);
        if (originalFile == null) {
            return null;
        }
        String path = originalFile.getURL();
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        return originalFile;
    }

    private com.tandbergtv.metadatamanager.model.File getOriginalFile(Asset asset) {
        if (asset == null) {
            return null;
        }
        List files = asset.getDirectDescendantFiles();
        com.tandbergtv.metadatamanager.model.File originalFile = null;
        for (com.tandbergtv.metadatamanager.model.File file : files) {
            if (!file.isOriginal()) continue;
            originalFile = file;
            break;
        }
        return originalFile;
    }

    private ThumbnailGeneratorFactory getThumbnailGeneratorFactory() {
        if (this.thumbnailGeneratorFactory == null) {
            this.thumbnailGeneratorFactory = ThumbnailGeneratorFactory.getInstance();
        }
        return this.thumbnailGeneratorFactory;
    }

    private IThumbnailGenerator getThumbnailGenerator() {
        if (this.thumbnailGenerator == null) {
            this.thumbnailGenerator = this.getThumbnailGeneratorFactory().createThumbnailGenerator();
        }
        return this.thumbnailGenerator;
    }

    private void generateThumbnails(Title title, List<GenerateThumbnailResult> unGeneratedThumbnailResults, ITitleAssetResourceManager resourceManager) {
        try {
            AssetsManager assetsManager = AssetsManager.getThreadLocalInstance();
            ThumbnailGeneratorFactory factory = this.getThumbnailGeneratorFactory();
            String format = factory.getThumbnailFormat();
            IThumbnailGenerator generator = this.getThumbnailGenerator();
            for (GenerateThumbnailResult result : unGeneratedThumbnailResults) {
                result.setThumbnailPath(this.getThumbnailPath(title, result.getAsset(), assetsManager, format));
            }
            for (GenerateThumbnailResult generateImageResult : unGeneratedThumbnailResults) {
                resourceManager.registerThumbnail(title.getId().longValue(), generateImageResult.getAsset().getId(), generateImageResult.getAsset().getType(), generateImageResult.getThumbnailPath());
            }
            TransactionalRegister.getInstance().registerCommitCallback(t -> generator.generateTitleThumbnails(title.getId().longValue(), unGeneratedThumbnailResults));
        }
        catch (Exception e) {
            logger.error((Object)("fail to generate thumbnails for title [" + title.getId() + "]:"), (Throwable)e);
        }
    }

    private String getThumbnailPath(Title title, Asset asset, AssetsManager assetsManager, String format) {
        StringBuilder thumbnailPath = new StringBuilder(assetsManager.getDerivedFilesDirectory(title));
        thumbnailPath.append(File.separator).append(THUMBNAIL_FOLDER).append(File.separator).append("asset_").append(asset.getId()).append("_").append(System.currentTimeMillis()).append(".").append(format.toLowerCase());
        return thumbnailPath.toString();
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        return (T)((Service)ServiceRegistry.getDefault().lookup(serviceClass));
    }
}

