/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.AutofillProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AutofillProviderFactory {
    private AutofillProviderFactory() {
    }

    public static List<AutofillProvider> createAutofillProviderList(Map<String, String> props) {
        if (props == null || props.isEmpty()) {
            return null;
        }
        HashMap<String, AutofillProvider> map = new HashMap<String, AutofillProvider>();
        for (String key : props.keySet()) {
            int endIdx;
            int startIdx = key.indexOf(91);
            if (startIdx < 0 || (endIdx = key.indexOf(93)) < 0) continue;
            String index = key.substring(startIdx, endIdx);
            AutofillProvider provider = (AutofillProvider)map.get(index);
            if (provider == null) {
                provider = new AutofillProvider();
                map.put(index, provider);
            }
            if (key.endsWith(".javaClass")) {
                provider.setJavaClass(props.get(key));
                continue;
            }
            if (!key.endsWith(".displayName")) continue;
            provider.setDisplayName(props.get(key));
        }
        if (!map.isEmpty()) {
            ArrayList<AutofillProvider> list = new ArrayList<AutofillProvider>();
            list.addAll(map.values());
            Collections.sort(list);
            return list;
        }
        return null;
    }
}

