/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.ingest;

import com.ericsson.cms.content.util.ContentServerUtil;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.title.ingest.FileMapResult;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileToAssetMappingResolver {
    private static ITitleManager titleManager = FileToAssetMappingResolver.getService(ITitleManager.class);

    private FileToAssetMappingResolver() {
    }

    private static <T extends Service> T getService(Class<T> serviceClass) {
        return (T)((Service)ServiceRegistry.getDefault().lookup(serviceClass));
    }

    public static Map<String, FileMapResult> mapFilesForPackage(String metadataPath, String assetFolderPath, Title title) throws TitleIngestException {
        TitleUtil.validIngestFolder(assetFolderPath);
        FileMapResult metadataMapping = FileToAssetMappingResolver.mapFile(title, title.getAsset(), metadataPath, true);
        List<FileMapResult> contentMappings = FileToAssetMappingResolver.getAssetsInFolder(title, assetFolderPath);
        HashMap<String, FileMapResult> mappings = new HashMap<String, FileMapResult>();
        mappings.put(metadataPath, metadataMapping);
        for (FileMapResult fmr : contentMappings) {
            mappings.put(fmr.getPath(), fmr);
        }
        return mappings;
    }

    public static FileMapResult mapFile(Title title, Asset asset, String filePath, boolean isMetadata) throws TitleIngestException {
        return FileToAssetMappingResolver.mapFile(title, asset, filePath, ContentServerUtil.fileSize(filePath), isMetadata);
    }

    public static FileMapResult mapFile(Title title, Asset asset, String filePath, String size, boolean isMetadata) {
        com.tandbergtv.metadatamanager.model.File newFile = titleManager.createOriginalFile();
        newFile.addField(new Field(FieldName.FILE_URL.toString(), filePath));
        if (size != null) {
            newFile.addField(new Field(FieldName.FILE_SIZE.toString(), size));
        }
        title.addFile(asset, newFile);
        return new FileMapResult(filePath, asset, newFile, isMetadata);
    }

    private static List<FileMapResult> getAssetsInFolder(Title title, String assetFolderPath) throws TitleIngestException {
        Map<String, String> fileSizeMap = ContentServerUtil.fileListSize(assetFolderPath);
        ArrayList<FileMapResult> fileMapResults = new ArrayList<FileMapResult>();
        for (Map.Entry<String, String> fileSizeEntry : fileSizeMap.entrySet()) {
            if (FileToAssetMappingResolver.isMetadataFile(fileSizeEntry.getKey())) continue;
            fileMapResults.add(FileToAssetMappingResolver.mapContentFile(title, fileSizeEntry.getKey(), fileSizeEntry.getValue(), assetFolderPath));
        }
        return fileMapResults;
    }

    private static FileMapResult mapContentFile(Title title, String assetFile, String fileSize, String assetFolder) throws TitleIngestException {
        Path assetFilePath;
        Path assetFolderPath = Paths.get(assetFolder, new String[0]);
        String relativeFilepath = assetFolderPath.relativize(assetFilePath = Paths.get(assetFile, new String[0])).toString();
        Asset matchingAsset = FileToAssetMappingResolver.findAssetWithRelativeFilepath(title, relativeFilepath);
        if (matchingAsset == null) {
            return new FileMapResult(assetFile, null, null, false);
        }
        return FileToAssetMappingResolver.mapFile(title, matchingAsset, assetFile, fileSize, false);
    }

    private static Asset findAssetWithRelativeFilepath(Title title, String relativeFilepath) throws TitleIngestException {
        if (title == null || title.getAsset() == null) {
            return null;
        }
        Asset result = null;
        for (Asset a : title.getAllAssets(false)) {
            if (!TitleUtil.compareFileNames(relativeFilepath, FileToAssetMappingResolver.getFieldValueOfAssetFile(a))) continue;
            if (result != null) {
                throw new TitleIngestException("Title has more than one asset with content file name: " + relativeFilepath);
            }
            result = a;
        }
        return result;
    }

    private static String getFieldValueOfAssetFile(Asset asset) {
        Field fileNameField = asset.getFirstField(FieldName.URL.toString());
        if (fileNameField == null || fileNameField.getValue() == null) {
            return null;
        }
        String value = fileNameField.getValue();
        if (value.startsWith("/") || value.startsWith("\\")) {
            value = value.replaceAll("^([/|\\\\]+)", "");
        }
        return value;
    }

    public static boolean isMetadataFile(String fileName) {
        return fileName.toLowerCase().endsWith(".xml");
    }

    public static Map<String, FileMapResult> mapContent(Title title, Asset asset, String assetPath) throws TitleIngestException {
        HashMap<String, FileMapResult> result = new HashMap<String, FileMapResult>();
        FileMapResult mapping = FileToAssetMappingResolver.moveAndMapFile(title, asset, assetPath, false);
        result.put(assetPath, mapping);
        return result;
    }

    public static Map<String, FileMapResult> onlyMapContent(Title title, Asset asset, String assetPath) throws TitleIngestException {
        HashMap<String, FileMapResult> result = new HashMap<String, FileMapResult>();
        FileMapResult mapping = FileToAssetMappingResolver.mapFile(title, asset, assetPath, null, false);
        result.put(assetPath, mapping);
        return result;
    }

    private static FileMapResult moveAndMapFile(Title title, Asset asset, String filePath, boolean isMetadata) throws TitleIngestException {
        String mappedFilePath = filePath;
        if (FileToAssetMappingResolver.getAssetsManager().isUnmappedFilePath(filePath)) {
            mappedFilePath = FileToAssetMappingResolver.moveToMappedLocation(filePath);
        }
        return FileToAssetMappingResolver.mapFile(title, asset, mappedFilePath, isMetadata);
    }

    private static AssetsManager getAssetsManager() {
        return AssetsManager.getThreadLocalInstance();
    }

    private static String moveToMappedLocation(String filePath) throws TitleIngestException {
        try {
            return FileToAssetMappingResolver.getAssetsManager().moveToMappedFilesDirectory(filePath);
        }
        catch (IOException e) {
            throw new TitleIngestException("Failed to move file " + filePath + " to the mapped folder location, error:" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static Collection<String> findUnmappedContentFiles(String providerId, Asset asset) throws TitleIngestException {
        String fileName = FileToAssetMappingResolver.getAssetFileName(asset);
        try {
            return FileToAssetMappingResolver.getAssetsManager().getUnmappedFiles(fileName, providerId);
        }
        catch (IOException e) {
            String msg = "Failed to get unmapped file paths for file name: " + fileName + ", error: " + e.getLocalizedMessage();
            throw new TitleIngestException(msg, (Throwable)e);
        }
    }

    public static Asset findAssetByFileName(Title title, String fileName) throws TitleIngestException {
        if (title == null || title.getAsset() == null) {
            return null;
        }
        Asset result = null;
        for (Asset a : title.getAllAssets(false)) {
            if (!TitleUtil.compareFileNames(fileName, FileToAssetMappingResolver.getAssetFileName(a))) continue;
            if (result != null) {
                throw new TitleIngestException("Title has more than one asset with content file name: " + fileName);
            }
            result = a;
        }
        return result;
    }

    public static String getAssetFileName(Asset asset) {
        String fileNameValue = FileToAssetMappingResolver.getFieldValueOfAssetFile(asset);
        if (fileNameValue == null) {
            return null;
        }
        int pathSeperaterIndex = fileNameValue.lastIndexOf(File.separator);
        if (pathSeperaterIndex < 0) {
            return fileNameValue;
        }
        return fileNameValue.substring(pathSeperaterIndex + 1, fileNameValue.length());
    }
}

