/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.ingest;

import com.ericsson.cms.content.util.ContentServerUtil;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.entities.FileSearchResult;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleDocumentActionException;
import com.tandbergtv.watchpoint.pmm.title.TitleOperationTypeEnum;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.ingest.ContentMapping;
import com.tandbergtv.watchpoint.pmm.title.ingest.FileMapResult;
import com.tandbergtv.watchpoint.pmm.title.ingest.FileToAssetMappingResolver;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngestService;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleAsset;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleAssetMapping;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestResult;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseManager;
import com.tandbergtv.watchpoint.pmm.util.email.EmailNotificationHandler;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class TitleIngestService
implements ITitleIngestService {
    private static final String PARAM_NAME_METADATA_PATH = "metadataPath";
    private static final String PARAM_NAME_ASSET_FOLDER_PATH = "assetFolderPath";
    private static final String PARAM_NAME_TITLE_ID = "titleId";
    private static final String PARAM_NAME_PROVIDE_ID = "providerId";
    private static final String PARAM_NAME_SOURCE = "source";
    private static final String PARAM_NAME_DOCUMENT = "document";
    private static final String PARAM_NAME_ASSET_PATH = "assetPath";
    private static final String PARAM_NAME_TITLE = "title";
    private static final String PARAM_NAME_ASSET_ID = "assetId";
    private static final String PARAM_NAME_CONTENT_FILE_PATH = "contentFilePath";
    private static final String FILE_SEPARATOR = "/";
    private ITitleManager titleManager;
    private IContentClassService contentClassService;
    private IPartnerManagement partnerManagement;
    private ITitleStatusService statusService;
    private ITitleSearchService titleSearchService;
    private static Logger logger = Logger.getLogger(TitleIngestService.class);

    public void start() {
        this.titleManager = this.getService(ITitleManager.class);
        this.contentClassService = this.getService(IContentClassService.class);
        this.partnerManagement = this.getService(IPartnerManagement.class);
        this.statusService = new TitleStatusService();
        this.titleSearchService = this.getService(ITitleSearchService.class);
    }

    public void stop() {
        this.titleManager = null;
        this.contentClassService = null;
        this.partnerManagement = null;
        this.statusService = null;
        this.titleSearchService = null;
    }

    public String getServiceName() {
        return "Title Ingest Service";
    }

    @Transactional
    public ContentMapping getMappingForMetadata(String metadataPath) throws TitleIngestException {
        this.validateNotNull(PARAM_NAME_METADATA_PATH, metadataPath);
        MetadataDocument document = this.createDocument(metadataPath, null);
        Long titleId = this.getTitleID(document);
        ArrayList<TitleAsset> titleAssets = new ArrayList<TitleAsset>();
        if (titleId != null) {
            Title title = this.getTitle(titleId);
            titleAssets.add(new TitleAsset(title.getId(), Long.valueOf(title.getAsset().getId())));
        }
        return new ContentMapping(metadataPath, titleAssets);
    }

    @Transactional
    public ContentMapping getMappingForContent(String assetPath, String providerId) {
        String fileName = new File(assetPath).getName();
        List searchResults = this.titleSearchService.findAssetWithFileName(fileName, providerId);
        ArrayList<TitleAsset> titleAssets = new ArrayList<TitleAsset>(searchResults.size());
        for (FileSearchResult fsr : searchResults) {
            titleAssets.add(new TitleAsset(Long.valueOf(fsr.getTitleId()), Long.valueOf(fsr.getAssetId())));
        }
        return new ContentMapping(assetPath, titleAssets);
    }

    public TitleIngestResult createTitleForPackage(String metadataPath, String assetFolderPath, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException {
        this.validateNotNull(PARAM_NAME_METADATA_PATH, metadataPath);
        this.validateNotNull(PARAM_NAME_ASSET_FOLDER_PATH, assetFolderPath);
        this.validateNotNull(PARAM_NAME_PROVIDE_ID, providerId);
        this.validateNotNull(PARAM_NAME_SOURCE, source);
        Title title = this.createTitle(metadataPath, null, providerId, contentClassName);
        Map<String, FileMapResult> mappings = FileToAssetMappingResolver.mapFilesForPackage(metadataPath, assetFolderPath, title);
        return this.saveTitleAndSendStatusNotification(title, source, null, mappings, true);
    }

    public TitleIngestResult updateTitleForPackage(String metadataPath, String assetFolderPath, Long titleId, ITitleActionSource source) throws TitleIngestException {
        this.validateNotNull(PARAM_NAME_METADATA_PATH, metadataPath);
        this.validateNotNull(PARAM_NAME_ASSET_FOLDER_PATH, assetFolderPath);
        this.validateNotNull(PARAM_NAME_TITLE_ID, titleId);
        this.validateNotNull(PARAM_NAME_SOURCE, source);
        Title title = this.updateTitle(metadataPath, null, titleId);
        Map<String, FileMapResult> mappings = FileToAssetMappingResolver.mapFilesForPackage(metadataPath, assetFolderPath, title);
        Long plannerId = this.getPlannerId(title);
        return this.saveTitleAndSendStatus(title, source, plannerId, mappings, true);
    }

    public String getMetadataPathForPackage(String packageFolderPath) throws TitleIngestException {
        TitleUtil.validIngestFolder(packageFolderPath);
        List<String> packageFiles = ContentServerUtil.listSubFilePaths(packageFolderPath);
        List metaDataFiles = packageFiles.stream().filter(FileToAssetMappingResolver::isMetadataFile).collect(Collectors.toList());
        if (metaDataFiles == null || metaDataFiles.isEmpty()) {
            throw new TitleIngestException("The folder " + packageFolderPath + " does not contain an xml file.");
        }
        if (metaDataFiles.size() > 1) {
            throw new TitleIngestException("The folder " + packageFolderPath + " contains more than one xml file.");
        }
        return (String)metaDataFiles.get(0);
    }

    public TitleIngestResult updateTitleForContent(String assetPath, Title title, ITitleActionSource source) throws TitleIngestException {
        this.validateNotNull(PARAM_NAME_ASSET_PATH, assetPath);
        this.validateNotNull(PARAM_NAME_TITLE, title);
        this.validateNotNull(PARAM_NAME_SOURCE, source);
        Asset asset = this.getSingleAssetInTitle(assetPath, title.getId(), title);
        return this.updateTitleForContent(assetPath, title, asset, source);
    }

    public TitleIngestResult createTitleForMetadata(String metadataPath, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException {
        this.validateNotNull(PARAM_NAME_METADATA_PATH, metadataPath);
        this.validateNotNull(PARAM_NAME_PROVIDE_ID, providerId);
        this.validateNotNull(PARAM_NAME_SOURCE, source);
        Title title = this.createTitle(metadataPath, null, providerId, contentClassName);
        Map<String, FileMapResult> mappings = this.mapMetadata(metadataPath, title);
        return this.saveTitleAndSendStatusNotification(title, source, null, mappings, false);
    }

    public ISavedTitle createTitleForMetadata(Document document, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException {
        this.validateNotNull(PARAM_NAME_DOCUMENT, document);
        this.validateNotNull(PARAM_NAME_PROVIDE_ID, providerId);
        this.validateNotNull(PARAM_NAME_SOURCE, source);
        Title title = this.createTitle(null, document, providerId, contentClassName);
        return this.saveTitleAndSendStatusNotification(title, source, null);
    }

    public ISavedTitle updateTitleForMetadata(Document document, Long titleId, ITitleActionSource source) throws TitleIngestException {
        this.validateNotNull(PARAM_NAME_DOCUMENT, document);
        this.validateNotNull(PARAM_NAME_TITLE_ID, titleId);
        this.validateNotNull(PARAM_NAME_SOURCE, source);
        Title title = this.updateTitle(null, document, titleId);
        Long plannerId = this.getPlannerId(title);
        return this.saveTitleAndSendStatus(title, source, plannerId);
    }

    public TitleIngestResult updateTitleForMetadata(String metadataPath, Long titleId, ITitleActionSource source) throws TitleIngestException {
        this.validateNotNull(PARAM_NAME_METADATA_PATH, metadataPath);
        this.validateNotNull(PARAM_NAME_TITLE_ID, titleId);
        this.validateNotNull(PARAM_NAME_SOURCE, source);
        Title title = this.updateTitle(metadataPath, null, titleId);
        Map<String, FileMapResult> mappings = this.mapMetadata(metadataPath, title);
        Long plannerId = this.getPlannerId(title);
        return this.saveTitleAndSendStatus(title, source, plannerId, mappings, false);
    }

    @Transactional
    public ISavedTitle saveTitleAndSendStatusNotification(Title title, ITitleActionSource source, Long plannerId) throws TitleIngestException {
        ISavedTitle savedTitle = this.saveTitleAndSendStatus(title, source, plannerId);
        this.createIngestedTitleMericsLog(savedTitle);
        this.sendSuccessfulIngestNotification(title);
        return savedTitle;
    }

    @Transactional
    public ISavedTitle saveTitleAndSendStatus(Title title, ITitleActionSource source, Long plannerId) throws TitleIngestException {
        long start = System.currentTimeMillis();
        ISavedTitle savedTitle = this.saveTitle(title, source);
        logger.debug((Object)MessageFormat.format("Time taken to saveTitle - titleId:{0} - time:{1}", title.getId(), System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.sendProgressUpdateForMetadata(savedTitle.getTitle(), plannerId, source);
        logger.debug((Object)MessageFormat.format("Time taken to send progress updates - titleId:{0} - time:{1}", title.getId(), System.currentTimeMillis() - start));
        return savedTitle;
    }

    @Transactional
    public TitleIngestResult saveTitleAndSendStatusNotification(Title title, ITitleActionSource source, Long plannerId, Map<String, FileMapResult> mappings, boolean isPackage) throws TitleIngestException {
        TitleIngestResult result = this.saveTitleAndSendStatus(title, source, plannerId, mappings, isPackage);
        this.createIngestedTitleMericsLog(result.getSavedTitle());
        this.sendSuccessfulIngestNotification(title);
        return result;
    }

    @Transactional
    public TitleIngestResult saveTitleAndSendStatus(Title title, ITitleActionSource source, Long plannerId, Map<String, FileMapResult> mappings, boolean isPackage) throws TitleIngestException {
        long start = System.currentTimeMillis();
        ISavedTitle savedTitle = this.saveTitle(title, source);
        logger.debug((Object)MessageFormat.format("Time taken to saveTitle - titleId:{0} - time:{1}", title.getId(), System.currentTimeMillis() - start));
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, plannerId);
        start = System.currentTimeMillis();
        this.sendProgressUpdateForMetadata(result, source);
        if (isPackage) {
            this.sendProgressUpdateForAssets(result, source);
        }
        logger.debug((Object)MessageFormat.format("Time taken to send progress updates - titleId:{0} - time:{1}", title.getId(), System.currentTimeMillis() - start));
        return result;
    }

    private Map<String, FileMapResult> mapMetadata(String metadataPath, Title title) throws TitleIngestException {
        HashMap<String, FileMapResult> result = new HashMap<String, FileMapResult>();
        FileMapResult mapping = FileToAssetMappingResolver.mapFile(title, title.getAsset(), metadataPath, true);
        result.put(metadataPath, mapping);
        return result;
    }

    @Transactional
    public List<Asset> getContentAssets(Long titleId) throws TitleIngestException {
        this.validateNotNull(PARAM_NAME_TITLE_ID, titleId);
        Title title = this.getTitle(titleId);
        ArrayList<Asset> result = new ArrayList<Asset>();
        for (Asset asset : title.getAllAssets(false)) {
            if (!this.assetHasContentUrl(asset)) continue;
            result.add(asset);
        }
        return result;
    }

    @Transactional
    public Collection<TitleAssetMapping> getUnmappedContentForTitle(Long titleId) throws TitleIngestException {
        this.validateNotNull(PARAM_NAME_TITLE_ID, titleId);
        ArrayList<TitleAssetMapping> result = new ArrayList<TitleAssetMapping>();
        Title title = this.getTitle(titleId);
        String providerId = this.getProviderId(title);
        for (Asset asset : title.getAllAssets(false)) {
            if (!this.assetHasContentUrl(asset)) continue;
            result.add(this.getUnmappedContentForTitleAsset(title, asset, providerId));
        }
        return result;
    }

    @Transactional
    public TitleAssetMapping getUnmappedContentForTitleAsset(Long titleId, Long assetId) throws TitleIngestException {
        Title title = this.getTitle(titleId);
        Asset asset = title.getAsset(assetId.longValue());
        String providerId = this.getProviderId(title);
        return this.getUnmappedContentForTitleAsset(title, asset, providerId);
    }

    private TitleAssetMapping getUnmappedContentForTitleAsset(Title title, Asset asset, String providerId) throws TitleIngestException {
        TitleAsset titleAsset = new TitleAsset(title.getId(), Long.valueOf(asset.getId()));
        Collection<String> filePaths = FileToAssetMappingResolver.findUnmappedContentFiles(providerId, asset);
        return new TitleAssetMapping(titleAsset, filePaths);
    }

    @Transactional
    public TitleIngestResult updateTitleForContent(String assetPath, Long titleId, ITitleActionSource source) throws TitleIngestException {
        this.validateNotNull(PARAM_NAME_ASSET_PATH, assetPath);
        this.validateNotNull(PARAM_NAME_TITLE_ID, titleId);
        this.validateNotNull(PARAM_NAME_SOURCE, source);
        Title title = this.getTitleForIngest(titleId, true);
        Asset asset = this.getSingleAssetInTitle(assetPath, titleId, title);
        return this.updateTitleForContent(assetPath, title, asset, source);
    }

    @Transactional
    public TitleIngestResult updateTitleForContent(String assetPath, Long titleId, Long assetId, ITitleActionSource source) throws TitleIngestException {
        return this.updateTitleForContent(assetPath, titleId, assetId, source, false);
    }

    @Transactional
    public TitleIngestResult updateTitleForContent(String assetPath, Long titleId, Long assetId, ITitleActionSource source, boolean registerPathOnly) throws TitleIngestException {
        this.validateNotNull(PARAM_NAME_ASSET_PATH, assetPath);
        this.validateFilePath(PARAM_NAME_ASSET_PATH, assetPath);
        this.validateNotNull(PARAM_NAME_TITLE_ID, titleId);
        this.validateNotNull(PARAM_NAME_ASSET_ID, assetId);
        this.validateNotNull(PARAM_NAME_SOURCE, source);
        Title title = this.getTitleForIngest(titleId, true);
        long start = System.currentTimeMillis();
        Asset asset = title.getAsset(assetId.longValue());
        logger.debug((Object)String.format("Time taken to get the asset: time = %d ms, titleId = %d", System.currentTimeMillis() - start, titleId));
        return this.updateTitleForContent(assetPath, title, asset, source, registerPathOnly);
    }

    private Asset getSingleAssetInTitle(String assetPath, Long titleId, Title title) throws TitleIngestException {
        String assetName = new File(assetPath).getName();
        Asset asset = FileToAssetMappingResolver.findAssetByFileName(title, assetName);
        if (asset == null) {
            throw new TitleIngestException("There should be one asset with name " + assetName + " in the title[" + titleId + "], but none were found.");
        }
        return asset;
    }

    private TitleIngestResult updateTitleForContent(String assetPath, Title title, Asset asset, ITitleActionSource source) throws TitleIngestException {
        return this.updateTitleForContent(assetPath, title, asset, source, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TitleIngestResult updateTitleForContent(String assetPath, Title title, Asset asset, ITitleActionSource source, boolean registerPathOnly) throws TitleIngestException {
        ISavedTitle savedTitle;
        Long plannerId;
        Map<String, FileMapResult> mappings;
        AssetsManager.getThreadLocalInstance().beginTransaction();
        boolean success = false;
        try {
            mappings = !registerPathOnly ? FileToAssetMappingResolver.mapContent(title, asset, assetPath) : FileToAssetMappingResolver.onlyMapContent(title, asset, assetPath);
            plannerId = this.getPlannerId(title);
            savedTitle = this.saveTitle(title, source);
            success = true;
        }
        finally {
            if (success) {
                AssetsManager.getThreadLocalInstance().commitTransaction();
            } else {
                AssetsManager.getThreadLocalInstance().rollbackTransaction();
            }
        }
        TitleIngestResult result = new TitleIngestResult(savedTitle, mappings, plannerId);
        this.sendProgressUpdateForAssets(result, source);
        return result;
    }

    public String generateUnmappedContentPath(String contentFilePath, String providerId) {
        this.validateNotNull(PARAM_NAME_CONTENT_FILE_PATH, contentFilePath);
        this.validateNotNull(PARAM_NAME_PROVIDE_ID, providerId);
        String fileName = new File(contentFilePath).getName();
        return this.getUnmappedFilesDirectory() + File.separator + providerId + File.separator + fileName + "_" + System.currentTimeMillis() + File.separator + fileName;
    }

    private Title createTitleForDocument(MetadataDocument document, String providerId, String contentClassName) throws TitleIngestException {
        this.checkLicense(contentClassName);
        try {
            List refTitleIds;
            Title title = new Title();
            Asset mergedAsset = this.mergeDocument(null, document);
            title.setAsset(mergedAsset);
            title.setPartnerId(this.getPartnerId(providerId));
            title.setContentClassId(this.getContentClassId(contentClassName));
            if (contentClassName != null && contentClassName.equals(ContentClass.Type.Offer.toString()) && (refTitleIds = ((Group)title.getAsset()).getReferencedTitleIds()) == null) {
                ((Group)title.getAsset()).setReferencedTitleIds(new ArrayList());
            }
            long start = System.currentTimeMillis();
            this.contentClassService.applyContentClassMetadataForIngest(title);
            logger.debug((Object)("Time taken to applyContentClassMetadataForIngest " + (System.currentTimeMillis() - start)));
            return title;
        }
        catch (MetadataException e) {
            throw new TitleIngestException("Failed to create title with " + document + ", error: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ContentClassPersistenceException e) {
            throw new TitleIngestException("Error applying content class when creating title with " + document + ", error: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Title updateTitleForDocument(Long titleId, MetadataDocument document) throws TitleIngestException {
        try {
            Title title = this.getTitleForIngest(titleId, false);
            Long rootAssetId = title.getAsset().getId();
            Asset mergedAsset = this.mergeDocument(rootAssetId, document);
            title.setAsset(mergedAsset);
            this.contentClassService.applyContentClassMetadataForIngest(title);
            return title;
        }
        catch (MetadataException e) {
            throw new TitleIngestException("Failed to update title[" + titleId + "] with " + document + ", error: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (ContentClassPersistenceException e) {
            throw new TitleIngestException("Error applying content class when updating title[" + titleId + "] with " + document + ", error: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Title getTitle(long titleId) throws TitleIngestException {
        Title title = this.titleManager.get(Long.valueOf(titleId));
        if (!title.getIsActive().booleanValue()) {
            String msg = "Title[" + titleId + "] is not active.";
            throw new TitleIngestException(msg);
        }
        return title;
    }

    private Title getTitleForIngest(long titleId, boolean allowCopy) throws TitleIngestException {
        Title title = this.titleManager.getForUpdate(Long.valueOf(titleId));
        if (!title.getIsActive().booleanValue()) {
            String msg = "Title[" + titleId + "] is not active.";
            throw new TitleIngestException(msg);
        }
        if (!allowCopy && title.isCopy()) {
            String msg = "Title[" + titleId + "] is a copy.";
            throw new TitleIngestException(msg);
        }
        return title;
    }

    private ISavedTitle saveTitle(Title title, ITitleActionSource source) throws TitleIngestException {
        ISavedTitle savedTitle = null;
        try {
            savedTitle = this.titleManager.save(title, source);
        }
        catch (TitleValidationException e) {
            throw new TitleIngestException(e.getLocalizedMessage(), (Throwable)e);
        }
        this.sendValidationFailureNotification(savedTitle, title);
        return savedTitle;
    }

    private void sendValidationFailureNotification(ISavedTitle savedTitle, Title title) {
        Partner partner;
        logger.debug((Object)"Checking email notification criteria for validation failure.");
        if (savedTitle.getValidationError() != null && savedTitle.getValidationError().getMessages() != null && !savedTitle.getValidationError().getMessages().isEmpty() && (partner = this.partnerManagement.getPartner(title.getPartnerId().longValue())).getIsEmailNotify() != null && partner.getIsEmailNotify().booleanValue() && partner.getContact().getEmail() != null && !partner.getContact().getEmail().trim().isEmpty()) {
            try {
                StringBuilder errorMsg = new StringBuilder();
                for (TitleValidationMessage tvmsg : savedTitle.getValidationError().getMessages()) {
                    if (!tvmsg.getIsEmailNotify() || tvmsg.getType() != TitleValidationMessage.Type.Error) continue;
                    errorMsg.append(tvmsg.getMessage());
                    errorMsg.append(System.getProperty("line.separator"));
                }
                if (errorMsg.length() > 0) {
                    List<String> recipent = this.getRecipentList(partner.getContact().getEmail());
                    EmailNotificationHandler emailUtility = new EmailNotificationHandler();
                    logger.info((Object)("Sending email notification for validation failed for titleId:" + title.getId() + " to recipient(s):" + recipent));
                    emailUtility.sendNotificationEmail(recipent, title, errorMsg.toString());
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send notification email for titleId = " + title.getId()), (Throwable)e);
            }
        }
    }

    private void sendSuccessfulIngestNotification(Title title) {
        logger.debug((Object)"Checking email notification criteria for Successful Ingest.");
        Partner partner = this.partnerManagement.getPartner(title.getPartnerId().longValue());
        if (title.getStatus() != TitleStatus.DRAFT && partner.getIsSuccessNotify() != null && partner.getIsSuccessNotify().booleanValue() && partner.getContact().getEmail() != null && !partner.getContact().getEmail().trim().isEmpty()) {
            try {
                List<String> recipent = this.getRecipentList(partner.getContact().getEmail());
                EmailNotificationHandler emailUtility = new EmailNotificationHandler();
                logger.info((Object)("Sending email notification for Successful Ingest for titleId:" + title.getId() + " to recipient(s):" + recipent));
                emailUtility.sendNotificationEmail(recipent, title, null);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to send notification email for titleId = " + title.getId()), (Throwable)e);
            }
        }
    }

    private List<String> getRecipentList(String email) {
        ArrayList<String> recipent = new ArrayList<String>();
        if (email.contains(";")) {
            String[] emails = email.split(";");
            for (int i = 0; i < emails.length; ++i) {
                recipent.add(emails[i]);
            }
        } else {
            recipent.add(email);
        }
        return recipent;
    }

    private boolean assetHasContentUrl(Asset asset) {
        return !this.isEmpty(FileToAssetMappingResolver.getAssetFileName(asset));
    }

    private Title createTitle(String metadataPath, Document document, String providerId, String contentClassName) throws TitleIngestException {
        long start = System.currentTimeMillis();
        MetadataDocument metadataDocument = this.createDocument(metadataPath, document);
        logger.debug((Object)("Time taken to createDocument - time:" + (System.currentTimeMillis() - start)));
        start = System.currentTimeMillis();
        this.validateDocumentForTitle(metadataDocument, null);
        logger.debug((Object)("Time taken to validateDocumentForTitle - time:" + (System.currentTimeMillis() - start)));
        start = System.currentTimeMillis();
        Title title = this.createTitleForDocument(metadataDocument, providerId, contentClassName);
        logger.debug((Object)MessageFormat.format("Time taken to createTitleForDocument - titleId:{0} - time:{1}", title.getId(), System.currentTimeMillis() - start));
        return title;
    }

    private Title updateTitle(String metadataPath, Document document, Long titleId) throws TitleIngestException {
        long start = System.currentTimeMillis();
        MetadataDocument metadataDocument = this.createDocument(metadataPath, document);
        logger.debug((Object)MessageFormat.format("Time taken to createDocument - titleId:{0} - time:{1}", titleId, System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.validateDocumentForTitle(metadataDocument, titleId);
        logger.debug((Object)MessageFormat.format("Time taken to validateDocumentForTitle - titleId:{0} - time:{1}", titleId, System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        Title title = this.updateTitleForDocument(titleId, metadataDocument);
        logger.debug((Object)MessageFormat.format("Time taken to updateTitleForDocument - titleId:{0} - time:{1}", titleId, System.currentTimeMillis() - start));
        return title;
    }

    private MetadataDocument createDocument(String filePath, Document document) throws TitleIngestException {
        if (filePath == null) {
            logger.debug((Object)("load the metadata from file path:" + filePath));
            return this.createMetadataDocument(document);
        }
        return this.createMetadataDocument(filePath);
    }

    private MetadataDocument createMetadataDocument(String filePath) throws TitleIngestException {
        Document document = null;
        try {
            long t1 = System.currentTimeMillis();
            byte[] bytes = ContentServerUtil.getFileContentAsBytes(filePath);
            long t2 = System.currentTimeMillis();
            logger.debug((Object)String.format("Time taken to get file content: time = %d ms, filePath = %s", t2 - t1, filePath));
            document = XmlUtil.borrowDocumentBuilder().parse(new ByteArrayInputStream(bytes));
            logger.debug((Object)String.format("Time taken to parse document: time = %d ms, filePath = %s", System.currentTimeMillis() - t2, filePath));
        }
        catch (Exception e) {
            throw new TitleIngestException("Unable to parse the metadata file: " + filePath, (Throwable)e);
        }
        return new MetadataDocument(filePath, document);
    }

    private MetadataDocument createMetadataDocument(Document document) {
        return new MetadataDocument(null, document);
    }

    private void validateDocumentForTitle(MetadataDocument metadataDocument, Long titleId) throws TitleIngestException {
        Long matchedTitleId = this.getTitleID(metadataDocument);
        if (matchedTitleId != null && !matchedTitleId.equals(titleId)) {
            String specificationName = this.getSpecHandler(metadataDocument).getSpecName();
            String operation = titleId != null ? "update title[" + titleId + "]" : "create title";
            String msg = "Could not " + operation + " for " + metadataDocument + ", title[" + matchedTitleId + "] has the same " + specificationName + " specification key.";
            throw new TitleIngestException(msg);
        }
    }

    private Long getTitleID(MetadataDocument metadataDocument) throws TitleIngestException {
        try {
            List titleIds = this.titleManager.getTitleIDs(metadataDocument.document);
            if (titleIds.size() != 1) {
                String msg = "There should be only one root asset in " + metadataDocument;
                throw new TitleIngestException(msg);
            }
            return (Long)titleIds.get(0);
        }
        catch (TitleDocumentActionException ex) {
            String msg = "Failed to determine title for " + metadataDocument + ", error: " + ex.getLocalizedMessage();
            throw new TitleIngestException(msg, (Throwable)ex);
        }
    }

    private Asset mergeDocument(Long rootAssetId, MetadataDocument document) throws TitleIngestException, MetadataException {
        ISpecHandler specHandler = this.getSpecHandler(document);
        List mergedAssets = rootAssetId == null ? specHandler.createNewAssetWithoutSave(document.document) : specHandler.mergeWithoutSave(rootAssetId, document.document);
        if (mergedAssets.size() != 1) {
            String msg = "The mergeWithoutSave operation should return exactly one asset, but " + mergedAssets.size() + " were found when merging " + document;
            throw new TitleIngestException(msg);
        }
        return (Asset)mergedAssets.get(0);
    }

    private ISpecHandler getSpecHandler(MetadataDocument document) throws TitleIngestException {
        ISpecHandler handler;
        ISpecificationManager service = this.getService(ISpecificationManager.class);
        Specification specification = service.getSpecificationForDocument(document.document);
        ISpecHandler iSpecHandler = handler = specification != null ? specification.getSpecHandler() : null;
        if (handler == null) {
            String msg = "Failed to match a specification for " + document + ". Check your license or the specification plugin(s).";
            throw new TitleIngestException(msg);
        }
        return handler;
    }

    private String getUnmappedFilesDirectory() {
        return this.getAssetsManager().getUnmappedFilesDirectory();
    }

    private AssetsManager getAssetsManager() {
        return AssetsManager.getThreadLocalInstance();
    }

    private void sendProgressUpdateForAssets(TitleIngestResult titleIngestResult, ITitleActionSource source) {
        Title ingestedTitle = titleIngestResult.getSavedTitle().getTitle();
        Long plannerId = titleIngestResult.getPlannerId();
        String sourceComponentName = source.getComponentName();
        String sourceEntityName = source.getEntityName();
        String sourceId = source.getID();
        Collection fileMappings = titleIngestResult.getMappings().values();
        for (FileMapResult fileMap : fileMappings) {
            if (fileMap.isMetadata() || !fileMap.isMapped()) continue;
            String assetType = fileMap.getParentAsset().getAssetType();
            this.statusService.sendAssetReceivedStatus(ingestedTitle, assetType, plannerId, sourceComponentName, sourceEntityName, sourceId);
        }
    }

    private void sendProgressUpdateForMetadata(TitleIngestResult titleIngestResult, ITitleActionSource source) {
        Title ingestedTitle = titleIngestResult.getSavedTitle().getTitle();
        Long plannerId = titleIngestResult.getPlannerId();
        String sourceComponentName = source.getComponentName();
        String sourceEntityName = source.getEntityName();
        String sourceId = source.getID();
        this.statusService.sendMetadataReceivedStatus(ingestedTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    private void sendProgressUpdateForMetadata(Title ingestedTitle, Long plannerId, ITitleActionSource source) {
        String sourceComponentName = source.getComponentName();
        String sourceEntityName = source.getEntityName();
        String sourceId = source.getID();
        this.statusService.sendMetadataReceivedStatus(ingestedTitle, plannerId, sourceComponentName, sourceEntityName, sourceId);
    }

    private Long getPartnerId(String providerId) throws TitleIngestException {
        Partner sourceOrSelfPartner;
        try {
            sourceOrSelfPartner = this.partnerManagement.getSourceOrSelfPartner(providerId);
        }
        catch (PMMException e) {
            logger.error((Object)e);
            throw new TitleIngestException(e.getMessage());
        }
        return sourceOrSelfPartner.getId();
    }

    private String getProviderId(Title title) {
        Partner partner = this.partnerManagement.getPartner(title.getPartnerId().longValue());
        return partner.getProviderId();
    }

    private Long getContentClassId(String contentClassName) throws TitleIngestException {
        long start = System.currentTimeMillis();
        try {
            if (this.isEmpty(contentClassName)) {
                return this.contentClassService.getDefaultContentClassId();
            }
            Long id = this.contentClassService.getContentClassIdByName(contentClassName);
            if (id == null) {
                String msg = "The content class[" + contentClassName + "] was not found.";
                throw new TitleIngestException(msg);
            }
            logger.debug((Object)("Time taken to getContentClassId " + (System.currentTimeMillis() - start)));
            return id;
        }
        catch (ContentClassPersistenceException e) {
            String msg = "Failed to get content class[" + contentClassName + "], error: " + e.getLocalizedMessage();
            throw new TitleIngestException(msg, (Throwable)e);
        }
    }

    private Long getPlannerId(Title title) {
        IScheduleSearchService scheduleSearchService = this.getService(IScheduleSearchService.class);
        Long result = scheduleSearchService.findEarliestUpcomingPlannerId(title);
        if (result == null) {
            result = scheduleSearchService.findPastPlannerId(title);
        }
        return result;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private void validateNotNull(String name, Object object) {
        if (Objects.isNull(object)) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    private void validateFilePath(String name, String filePath) {
        if (!filePath.startsWith(FILE_SEPARATOR)) {
            throw new IllegalArgumentException(name + " is invalid file path, it should start with " + FILE_SEPARATOR);
        }
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        return (T)((Service)ServiceRegistry.getDefault().lookup(serviceClass));
    }

    private void createIngestedTitleMericsLog(ISavedTitle savedTitle) {
        if (savedTitle != null && savedTitle.getTitle() != null) {
            TitleUtil.buildTitleMetricsLog(savedTitle.getTitle(), TitleOperationTypeEnum.Ingested);
        }
    }

    private void checkLicense(String contentClassName) {
        long start = System.currentTimeMillis();
        LicenseManager.getInstance().canCreateMasterTitle(LicenseFilter.newBuilder().setContentClassName(contentClassName).build());
        logger.debug((Object)("Time taken to checkLicense - time:" + (System.currentTimeMillis() - start)));
    }

    private static final class MetadataDocument {
        private final String path;
        private final Document document;

        public MetadataDocument(String path, Document document) {
            this.path = path;
            this.document = document;
        }

        public String toString() {
            return "metadata document[" + this.path + "]";
        }
    }
}

