/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.license;

import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseLimitException;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.LicenseMonitor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import org.apache.log4j.Logger;

public class LicenseManager {
    private static final Logger logger = Logger.getLogger(LicenseManager.class);

    LicenseManager() {
    }

    LicenseMonitor getLicenseMonitor() {
        return LicenseMonitor.getInstance();
    }

    public static LicenseManager getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public void canCreateMasterTitle(LicenseFilter filter) {
        if (this.isSkipCheckLicense(filter)) {
            return;
        }
        long currMasterTitleCount = this.getLicenseMonitor().getMasterTitleCount();
        long currTokenCount = this.getLicenseMonitor().getTokenUsage();
        long maxMasterTitleCount = this.getLicenseMonitor().getMaxMasterTitleCount();
        long totalTokenCount = this.getLicenseMonitor().getMaxToken();
        logger.debug((Object)String.format("License info in the system: %n- Current master title(s): %d%n- Current used token(s): %d%n- Title limit: %d%n- Total Token(s): %d%n", currMasterTitleCount, currTokenCount, maxMasterTitleCount, totalTokenCount));
        this.handleGetUsageException(currMasterTitleCount, currTokenCount, totalTokenCount);
        if (totalTokenCount != 0L && currTokenCount >= totalTokenCount) {
            throw new LicenseLimitException("Cannot create master or series titles. Token Limit [" + totalTokenCount + "] reached. ");
        }
        if (maxMasterTitleCount != 0L && currMasterTitleCount >= maxMasterTitleCount) {
            throw new LicenseLimitException("Cannot create master or series titles. Master Title Limit [" + maxMasterTitleCount + "] reached. ");
        }
    }

    private void handleGetUsageException(long currMasterTitleCount, long currTokenCount, long totalTokenCount) {
        if (currMasterTitleCount == Long.MAX_VALUE) {
            throw new LicenseLimitException("Current master title usage is under unhealthy status, title creation is therefore forbidden. ");
        }
        if (currTokenCount == Long.MAX_VALUE) {
            throw new LicenseLimitException("Current token usage is under unhealthy status, title creation is therefore forbidden. ");
        }
        if (totalTokenCount == -1L) {
            throw new LicenseLimitException("Total Token count is under unhealthy status, title creation is therefore forbidden. ");
        }
    }

    private boolean isSkipCheckLicense(LicenseFilter filter) {
        return this.isSkipCheckLicenseByContentClassType(filter);
    }

    private boolean isSkipCheckLicenseByContentClassType(LicenseFilter filter) {
        Long contentClassId = filter.getContentClassId();
        IContentClassService contentClassService = (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
        if (null == contentClassId) {
            String contentClassName = filter.getContentClassName();
            if (null == contentClassName) {
                return false;
            }
            try {
                contentClassId = contentClassService.getContentClassIdByName(contentClassName);
            }
            catch (ContentClassPersistenceException e) {
                logger.error((Object)new StringBuilder("Cannot get content class id by name from DB. Content class name: ").append(contentClassName), (Throwable)e);
            }
        }
        if (null == contentClassId) {
            return false;
        }
        ContentClass.Type type = null;
        try {
            type = contentClassService.getContentClassTypeById(contentClassId.longValue());
        }
        catch (ContentClassPersistenceException e) {
            logger.error((Object)new StringBuilder("Cannot get content class by id from DB. Content class id: ").append(contentClassId), (Throwable)e);
        }
        if (null == type) {
            return false;
        }
        for (ContentClass.Type contentClassType : LicenseFilter.CONTENT_CLASS_FILTER) {
            if (type != contentClassType) continue;
            return true;
        }
        return false;
    }

    private static class SingletonHelper {
        private static final LicenseManager INSTANCE = new LicenseManager();

        private SingletonHelper() {
        }
    }
}

