/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.message;

import com.ericsson.cms.neptune.rabbitmq.sender.IMessageSender;
import com.ericsson.cms.neptune.rabbitmq.sender.MessageSender;
import com.ericsson.cms.neptune.rabbitmq.sender.support.MessagePropertiesSetter;
import com.ericsson.cms.neptune.rabbitmq.service.RabbitMQService;
import com.google.common.collect.Maps;
import com.tandbergtv.watchpoint.pmm.title.message.IAggregateDistributionStatusProducer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class AggregateDistributionStatusProducer
implements IAggregateDistributionStatusProducer {
    public static final Logger logger = LoggerFactory.getLogger(AggregateDistributionStatusProducer.class);
    private RabbitMQService service;
    private IMessageSender messageSender;

    public AggregateDistributionStatusProducer(RabbitMQService service) {
        this.service = service;
    }

    public String getServiceName() {
        return "aggregate.distribution.status.service";
    }

    public void start() {
        this.service.start();
        RabbitTemplate rabbitTemplate = this.service.getRabbitTemplate();
        this.messageSender = new MessageSender(rabbitTemplate);
    }

    @Override
    public void sendAggregateDistributionStatusEventMessage(Long masterTitleId) {
        MessagePropertiesSetter messagePostProcessor;
        String message = masterTitleId + " " + System.currentTimeMillis();
        boolean isSendSucess = this.messageSender.sendWithSyncConfirm("cms.exchange.aggregate.distribution.status", "", (Object)message, messagePostProcessor = msg -> {
            HashMap headers = Maps.newHashMap();
            msg.setHeaders((Map)headers);
            return msg;
        });
        if (!isSendSucess) {
            logger.error("fail to publish the event message for master title Id: " + masterTitleId);
        }
    }

    @Override
    public void sendAggregateDistributionStatusUpdateMessage(Long masterTitleId) {
        MessagePropertiesSetter messagePostProcessor;
        String message = masterTitleId.toString();
        boolean isSendSucess = this.messageSender.sendWithSyncConfirm("", "cms.queue.aggregate.distribution.status.trigger", (Object)message, messagePostProcessor = msg -> {
            HashMap headers = Maps.newHashMap();
            msg.setHeaders((Map)headers);
            return msg;
        });
        if (!isSendSucess) {
            logger.error("fail to publish the update message for master title Id: " + masterTitleId);
        }
    }

    public void stop() {
        this.service.stop();
    }
}

