/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;

public abstract class CommonRabbitMQConfiguration {
    protected Map<String, Object> getQueueArgs() {
        HashMap<String, Object> arguments = new HashMap<String, Boolean>();
        arguments.put("durable", true);
        arguments.put("exclusive", false);
        arguments.put("autoDelete", false);
        arguments = Collections.unmodifiableMap(arguments);
        return arguments;
    }

    protected SimpleRabbitListenerContainerFactory newRabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        factory.setPrefetchCount(Integer.valueOf(10000));
        factory.setDefaultRequeueRejected(Boolean.valueOf(false));
        return factory;
    }
}

