/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.message;

import com.ericsson.cms.neptune.rabbitmq.service.RabbitMQServiceArguments;
import com.tandbergtv.watchpoint.pmm.title.message.CommonRabbitMQConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.Declarables;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@EnableRabbit
@Configuration
@ComponentScan
public class ThumbnailGeneratorConfiguration
extends CommonRabbitMQConfiguration {
    public static final String THUMBNAIL_GENERATOR_QUEUE = "cms.queue.thumbnail.generator";
    public static final String THUMBNAIL_GENERATOR_EXCHANGE = "cms.exchange.thumbnail.generator";
    public static final String THUMBNAIL_GENERATOR_EXCHANGE_RETRY = "cms.exchange.thumbnail.generator.retry";
    public static final String THUMBNAIL_GENERATOR_QUEUE_RETRY = "cms.queue.thumbnail.generator.retry";
    public static final String MATCH_ALL = "#";

    @Bean
    public Declarables thumbnailGeneratorResultDeclarables() {
        Exchange thumbnailGeneratorExchange = ExchangeBuilder.directExchange((String)THUMBNAIL_GENERATOR_EXCHANGE).build();
        Exchange thumbnailDelayRetryExchange = ExchangeBuilder.directExchange((String)THUMBNAIL_GENERATOR_EXCHANGE_RETRY).build();
        Queue thumbnailGeneratorQueue = QueueBuilder.durable((String)THUMBNAIL_GENERATOR_QUEUE).withArguments(this.getQueueArgs()).build();
        Queue thumbnailDelayRetryQueue = QueueBuilder.durable((String)THUMBNAIL_GENERATOR_QUEUE_RETRY).withArguments(ThumbnailGeneratorConfiguration.getDlxQueueArgument()).build();
        Binding dlxBinding = BindingBuilder.bind((Queue)thumbnailGeneratorQueue).to(thumbnailDelayRetryExchange).with(MATCH_ALL).noargs();
        Binding binding = BindingBuilder.bind((Queue)thumbnailGeneratorQueue).to(thumbnailGeneratorExchange).with("").noargs();
        Binding retryBinding = BindingBuilder.bind((Queue)thumbnailDelayRetryQueue).to(thumbnailGeneratorExchange).with(THUMBNAIL_GENERATOR_QUEUE_RETRY).noargs();
        return new Declarables(new Declarable[]{thumbnailGeneratorExchange, thumbnailDelayRetryExchange, thumbnailDelayRetryQueue, thumbnailGeneratorQueue, dlxBinding, binding, retryBinding});
    }

    @Bean(name={"thumbnailGeneratorResultRabbitListenerContainerFactory"})
    public SimpleRabbitListenerContainerFactory thumbnailGeneratorResultRabbitListenerContainerFactory(ConnectionFactory connectionFactory, RabbitTemplate rabbitTemplate) {
        SimpleRabbitListenerContainerFactory factory = this.newRabbitListenerContainerFactory(connectionFactory);
        factory.setMessageConverter(rabbitTemplate.getMessageConverter());
        return factory;
    }

    @Bean
    public RabbitMQServiceArguments rabbitMQComponentArguments() {
        RabbitMQServiceArguments arguments = new RabbitMQServiceArguments();
        arguments.setConnectionName("thumbnail-generator");
        return arguments;
    }

    private static Map<String, Object> getDlxQueueArgument() {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("x-dead-letter-exchange", THUMBNAIL_GENERATOR_EXCHANGE_RETRY);
        arguments.put("x-dead-letter-routing-key", MATCH_ALL);
        return arguments;
    }
}

