/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.message;

import com.ericsson.cms.neptune.rabbitmq.sender.IMessageSender;
import com.ericsson.cms.neptune.rabbitmq.sender.MessageSender;
import com.ericsson.cms.neptune.rabbitmq.sender.support.MessagePropertiesSetter;
import com.ericsson.cms.neptune.rabbitmq.service.RabbitMQService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.tandbergtv.watchpoint.pmm.title.message.IThumbnailGeneratorProducer;
import com.tandbergtv.watchpoint.pmm.title.message.ResizeImageMsg;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class ThumbnailGeneratorProducer
implements IThumbnailGeneratorProducer {
    public static final Logger logger = LoggerFactory.getLogger(ThumbnailGeneratorProducer.class);
    private static final int RETRY_INTERVAL = 3000;
    private static final int RETRY_COUNT = 3;
    private RabbitMQService service;
    private IMessageSender messageSender;
    private ObjectMapper objectMapper = new ObjectMapper();
    private MessagePropertiesSetter messagePostProcessor = msg -> {
        HashMap headers = Maps.newHashMap();
        msg.setHeaders((Map)headers);
        return msg;
    };

    public ThumbnailGeneratorProducer(RabbitMQService service) {
        this.service = service;
    }

    public String getServiceName() {
        return "thumbnail.generator.service";
    }

    public void start() {
        this.service.start();
        RabbitTemplate rabbitTemplate = this.service.getRabbitTemplate();
        this.messageSender = new MessageSender(rabbitTemplate);
    }

    @Override
    public void sendThumbnailGeneratorMessage(ResizeImageMsg resizeImageMsg) {
        String resizeImageMsgStr = this.objToString(resizeImageMsg);
        logger.info("start to send message:{}", (Object)resizeImageMsgStr);
        boolean isSendSuccess = this.messageSender.sendAndRetryWithSyncConfirm("cms.exchange.thumbnail.generator", "", (Object)resizeImageMsg, this.messagePostProcessor, 3, 3000);
        if (!isSendSuccess) {
            logger.error("fail to send message:" + resizeImageMsgStr);
        }
        logger.info("end to send message:{}", (Object)resizeImageMsgStr);
    }

    private String objToString(Object o) {
        try {
            return this.objectMapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            logger.error("convert obj to json failed", (Throwable)e);
            return "";
        }
    }

    public void stop() {
        this.service.stop();
    }
}

