/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.resource;

import com.ericsson.cms.content.util.ContentServerUtil;
import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.TitleResource;
import com.tandbergtv.watchpoint.pmm.title.ITitleResourceManager;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class TitleResourceManager
implements ITitleResourceManager {
    private static final Logger logger = Logger.getLogger(TitleResourceManager.class);
    private static final String CLEAN_TIME = "cleanTime";
    private static final String CLEAN_WAIT_PERIOD = "cleanWaitPeriod";
    private static final long DAY_IN_MS = 86400000L;
    private static final int CLEAN_WAIT_PERIOD_VALUE = 5;
    private static final String CLEAN_TIME_FORMAT = "HH:mm:ss";
    private ISchedulerService<Void> schedulerService;
    private IClusterService hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);

    @Override
    @Transactional
    public TitleResource get(Long id) {
        return (TitleResource)this.getSession().load(TitleResource.class, (Serializable)id);
    }

    @Override
    @Transactional
    public TitleResource save(TitleResource resource) {
        this.getSession().persist((Object)resource);
        return resource;
    }

    @Override
    @Transactional
    public boolean delete(Long id) {
        Session session = this.getSession();
        TitleResource entity = (TitleResource)session.get(TitleResource.class, (Serializable)id);
        ArrayList<String> fileUrls = new ArrayList<String>();
        fileUrls.add(entity.getResourcePath());
        try {
            ContentServerUtil.deleteFileAndEmptyParentDir(fileUrls);
        }
        catch (Exception e) {
            logger.warn((Object)("Failure deleting title[#" + entity.getTitleId() + "] resource: " + entity.getResourcePath()));
        }
        session.delete((Object)entity);
        return true;
    }

    @Override
    @Transactional
    public int batchDeleteFromDB(List<TitleResource> resources) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (TitleResource resource : resources) {
            ids.add(resource.getId());
        }
        Query query = this.getSession().createQuery("delete from TitleResource where id in (:ids)");
        query.setParameterList("ids", ids);
        return query.executeUpdate();
    }

    @Override
    public List<TitleResource> getByTitle(Long titleId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("titleID", titleId);
        return this.getList("TitleResource.GetByTitle", parameters);
    }

    @Override
    public List<TitleResource> getOrphans() {
        return this.getList("TitleResource.GetOrphans", null);
    }

    @Override
    public List<TitleResource> getByDeletedTitles() {
        return this.getList("TitleResource.GetByDeletedTitles", null);
    }

    @Override
    public List<TitleResource> getByPath(String resourcePath) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("resourcePath", resourcePath);
        return this.getList("TitleResource.GetByResourcePath", parameters);
    }

    @Transactional
    private List<TitleResource> getList(String queryName, Map<String, Object> parameters) {
        Query query = this.getSession().getNamedQuery(queryName);
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                query.setParameter(key, parameters.get(key));
            }
        }
        return query.list();
    }

    public String getServiceName() {
        return this.getClass().getSimpleName();
    }

    public void start() {
        if (this.hzcs.isMaster()) {
            this.schedulerService = new Scheduler("title-resource", 1, 1);
            this.schedulerService.start();
            long now = this.getCurrentTime().getTime();
            long cleanTime = this.getCleanTime().getTime();
            long delay = cleanTime - now;
            if (delay < 0L) {
                delay += 86400000L;
            }
            this.schedulerService.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        TitleResourceManager.this.cleanTitleResources();
                    }
                    catch (Throwable t) {
                        String msg = "Severe error when cleaning title resources for deleted titles and orphans.";
                        logger.error((Object)msg, t);
                    }
                }
            }, delay, 86400000L);
        }
    }

    public void stop() {
        if (this.schedulerService != null) {
            this.schedulerService.stop();
        }
        this.schedulerService = null;
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    private void cleanTitleResources() {
        try {
            logger.info((Object)"Executing scheduled task to clean title resources for orphan resources and deleted titles.");
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("days", this.getCleanWaitPeriod());
            List<TitleResource> resources = this.getList("TitleResource.GetForClean", parameters);
            int resourceCnt = resources.size();
            if (resourceCnt > 0) {
                logger.info((Object)("Found " + resourceCnt + " title resources for deletion that are orphans or belong to deleted titles."));
                ContentServerUtil.deleteFileAndEmptyParentDir(resources.stream().map(TitleResource::getResourcePath).collect(Collectors.toList()));
                this.batchDeleteFromDB(resources);
            }
        }
        catch (Exception e) {
            String msg = "Failed to get title resources for orphan and deleted titles for cleanup.";
            logger.error((Object)msg, (Throwable)e);
        }
    }

    private Date getCleanTime() {
        Date cleanTime = null;
        String value = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getName());
            value = bundle.getString(CLEAN_TIME);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get title resource clean time.", (Throwable)e);
        }
        SimpleDateFormat format = new SimpleDateFormat(CLEAN_TIME_FORMAT);
        if (value != null && value.trim().length() > 0) {
            try {
                cleanTime = format.parse(value);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to parse title resource clean time: '" + value + "' using format: " + CLEAN_TIME_FORMAT + ", using default."), (Throwable)e);
            }
        }
        if (cleanTime == null) {
            cleanTime = new Date();
        }
        return cleanTime;
    }

    private Date getCurrentTime() {
        try {
            SimpleDateFormat format = new SimpleDateFormat(CLEAN_TIME_FORMAT);
            return format.parse(format.format(new Date()));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get current time.", e);
        }
    }

    private int getCleanWaitPeriod() {
        int cleanWaitPeriod = -1;
        String value = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getName());
            value = bundle.getString(CLEAN_WAIT_PERIOD);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get title resource clean wait period.", (Throwable)e);
        }
        if (value != null && value.trim().length() > 0) {
            try {
                cleanWaitPeriod = Integer.parseInt(value);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to parse title resource clean wait period: '" + value + "' , using default."), (Throwable)e);
            }
        }
        if (cleanWaitPeriod <= 0) {
            cleanWaitPeriod = 5;
        }
        return cleanWaitPeriod;
    }
}

