/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.sites.core.ISitesCacheService;
import com.ericsson.cms.sites.core.entities.SiteCachable;
import com.tandbergtv.cms.title.search.BulkSearchRecordHandler;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.util.LocalizedMessageUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class ExportHelper
implements BulkSearchRecordHandler {
    private static final char DELIMITER = ',';
    private Charset charSet;
    private OutputStream outStream;
    private List<ColumnInfo> searchColumns;
    private CriteriaMode criteriaMode = CriteriaMode.MASTER;
    private SiteType siteType;
    private static final String STATUS = "status";
    private static final String MISSING_CONTENT = "missingContent";
    private static final String DISTRIBUTION_STATUS = "distributionStatus";
    private static final String DISTRIBUTION_SITE_ID = "distributionSiteId";
    private static final String PROCESSING_STATUS = "processingStatus";
    private static final String TRACKING_STATUS = "trackingStatus";
    private static final LocalizedMessageUtil TITLE_MESSAGE_UTIL = new LocalizedMessageUtil("content", "com.tandbergtv.cms.portal.ui.title.client.TitleConstants", null);
    private static final LocalizedMessageUtil TITLE_IMAGE_MESSAGE_UTIL = new LocalizedMessageUtil("content", "com.tandbergtv.cms.portal.ui.title.client.view.bundle.TitleImageConstants", null);
    private static final ISitesCacheService sitesCacheService = (ISitesCacheService)InjectionUtil.injectInstance((String)"cms/cms_sites_impl/SitesCacheService", ISitesCacheService.class);

    public ExportHelper(OutputStream outStream, Charset charSet, List<ColumnInfo> searchColumns) {
        this.outStream = outStream;
        this.charSet = charSet;
        this.searchColumns = searchColumns;
    }

    public void handleRecord(TitleSearchResult.SearchRow searchRow) throws IOException {
        this.handleRecords(Arrays.asList(searchRow));
    }

    public void handleRecords(List<TitleSearchResult.SearchRow> rows) throws IOException {
        ArrayList<String> lines = new ArrayList<String>(rows.size());
        for (TitleSearchResult.SearchRow row : rows) {
            lines.add(this.generateRecordStr(row));
        }
        IOUtils.writeLines(lines, (String)"\r\n", (OutputStream)this.outStream, (String)this.charSet.name());
    }

    private String generateRecordStr(TitleSearchResult.SearchRow searchRow) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.searchColumns.size(); ++i) {
            if (this.searchColumns.get(i).isQuickInfoField()) continue;
            String fieldName = this.searchColumns.get(i).getFieldName();
            if (STATUS.equals(fieldName)) {
                String keyPrefix = this.getKeyPrefixForStatus();
                this.encodeValue(sb, TITLE_IMAGE_MESSAGE_UTIL.getMessageValue(keyPrefix + searchRow.getCSVs(i)));
            } else if (MISSING_CONTENT.equals(fieldName)) {
                this.encodeValue(sb, this.localizeMissContentDescription(searchRow.getCSVs(i)));
            } else if (DISTRIBUTION_SITE_ID.equals(fieldName)) {
                SiteCachable site = sitesCacheService.getSite(Integer.valueOf(searchRow.getCSVs(i)));
                this.encodeValue(sb, site == null ? searchRow.getCSVs(i) : site.getName());
            } else if (DISTRIBUTION_STATUS.equals(fieldName)) {
                this.encodeValue(sb, TITLE_IMAGE_MESSAGE_UTIL.getMessageValue(DISTRIBUTION_STATUS + searchRow.getCSVs(i)));
            } else if (PROCESSING_STATUS.equals(fieldName)) {
                this.encodeValue(sb, TITLE_IMAGE_MESSAGE_UTIL.getMessageValue(PROCESSING_STATUS + searchRow.getCSVs(i)));
            } else {
                this.encodeValue(sb, searchRow.getCSVs(i));
            }
            sb.append(',');
        }
        return sb.toString();
    }

    private String getKeyPrefixForStatus() {
        String keyPrefix = STATUS;
        if (this.criteriaMode == CriteriaMode.SITE) {
            keyPrefix = SiteType.TRACKING_SITE == this.siteType ? TRACKING_STATUS : DISTRIBUTION_STATUS;
        }
        return keyPrefix;
    }

    private String localizeMissContentDescription(String missingContent) {
        String[] array = missingContent.replace("PACKAGE/", "").split(String.valueOf(','));
        StringBuilder missContentDes = new StringBuilder();
        for (String s : array) {
            int idx = s.indexOf(40);
            if (idx == -1) continue;
            missContentDes.append(TITLE_MESSAGE_UTIL.getMessageValue(s.substring(0, idx).trim().toLowerCase() + "Type"));
            missContentDes.append(s.substring(idx, s.length()));
            missContentDes.append(',');
            missContentDes.append(" ");
        }
        if (missContentDes.length() > 0) {
            return missContentDes.substring(0, missContentDes.length() - 2);
        }
        return missContentDes.toString();
    }

    public void encodeValue(StringBuilder sb, String value) {
        boolean wrapWithQuotes = false;
        int startIndex = sb.length();
        for (int i = 0; i < value.length(); ++i) {
            char chr = value.charAt(i);
            if (!(wrapWithQuotes || chr != ',' && chr != '\"')) {
                wrapWithQuotes = true;
                sb.insert(startIndex, '\"');
            }
            if (chr == '\"') {
                sb.append('\"');
            }
            if (chr == '\r' || chr == '\n') {
                sb.append(' ');
                continue;
            }
            sb.append(chr);
        }
        if (wrapWithQuotes) {
            sb.append('\"');
        }
    }

    public void addHeader() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (ColumnInfo ci : this.searchColumns) {
            if (ci.isQuickInfoField()) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            this.encodeValue(sb, ci.getDisplayName());
        }
        sb.append("\r\n");
        this.outStream.write(sb.toString().getBytes(this.charSet));
        this.outStream.flush();
    }

    public void setCriteriaMode(CriteriaMode criteriaMode) {
        this.criteriaMode = criteriaMode;
    }

    public void setSiteType(SiteType siteType) {
        this.siteType = siteType;
    }

    public static class ColumnInfo
    extends SearchColumn {
        private static final long serialVersionUID = -1143399035834295567L;
        private String displayName;
        private String fieldName;

        public ColumnInfo(String displayName, boolean quickInfoColumn, String fieldName, String sectionType, FieldType fieldType, String dataType, boolean multiValue) {
            super(sectionType, fieldName, fieldType, dataType, multiValue);
            this.setQuickInfoField(quickInfoColumn);
            this.displayName = displayName;
            this.fieldName = fieldName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

