/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.title.search.FlowerNumberConditionBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.FlowerStringConditionBuilder;
import java.util.List;

public class FlowerConditionBuilder {
    protected Predicate predicate;
    private SearchSchemaHelper searchSchemaHelper;

    protected FlowerConditionBuilder(Predicate predicate) {
        this.predicate = predicate;
    }

    protected String getRhsValue() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return (String)prv.getValue().get(0);
    }

    protected List<String> getValues() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return prv.getValue();
    }

    protected String getFullXpath() {
        StringBuffer sb = new StringBuffer(this.getXpathStart());
        if (!this.predicate.getFieldLeft().startsWith("/") && !this.predicate.getFieldLeft().isEmpty()) {
            sb.append("/");
        }
        sb.append(this.predicate.getFieldLeft());
        return sb.toString();
    }

    protected String getDollarPXpath() {
        return "$p" + this.getFullXpath();
    }

    private String getXpathStart() {
        return this.searchSchemaHelper.getEcmfComplientSectionType(this.predicate.getFieldLeftSectionType(), true);
    }

    protected String getXpathMinusTail() {
        StringBuffer sb = new StringBuffer(this.getXpathStart());
        int stopIndex = this.predicate.getFieldLeft().lastIndexOf("/");
        sb.append(this.predicate.getFieldLeft().substring(0, stopIndex));
        if (stopIndex == 0 && this.predicate.fieldLeftIsWildCard()) {
            sb.append("/*");
        }
        return sb.toString();
    }

    protected String getXpathTail() {
        int startIndex = this.predicate.getFieldLeft().lastIndexOf("/") + 1;
        return this.predicate.getFieldLeft().substring(startIndex);
    }

    protected String contains() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String endsWith() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String equal() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String greaterThan() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String greaterThanEqual() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String in() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String lessThan() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String lessThanEqual() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String notContains() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String notEqual() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String startsWith() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String notIn() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String between() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String doesNotEndWith() {
        throw new RuntimeException("Unsupported Operation");
    }

    protected String doesNotStartWith() {
        throw new RuntimeException("Unsupported Operation");
    }

    private static FlowerConditionBuilder getConditionBuilder(Predicate predicate) {
        DataTypeMappingReader dtr = DataTypeMappingReader.getInstance();
        String dataType = dtr.determineDataType(predicate.getFieldLeft());
        if (dataType == null) {
            return new FlowerConditionBuilder(predicate);
        }
        if (dataType.equals("integer") || dataType.equals("float")) {
            return new FlowerNumberConditionBuilder(predicate);
        }
        if (dataType.equals("string")) {
            return new FlowerStringConditionBuilder(predicate);
        }
        return new FlowerConditionBuilder(predicate);
    }

    private String getCondition() {
        switch (this.predicate.getSearchComplientOperator()) {
            case EQUAL: {
                return this.equal();
            }
            case NOTEQUAL: {
                return this.notEqual();
            }
            case LESSTHAN: {
                return this.lessThan();
            }
            case GREATERTHAN: {
                return this.greaterThan();
            }
            case LESSTHANEQUAL: {
                return this.lessThanEqual();
            }
            case GREATERTHANEQUAL: {
                return this.greaterThanEqual();
            }
            case CONTAINS: {
                return this.contains();
            }
            case DOESNOTCONTAIN: {
                return this.notContains();
            }
            case IN: {
                return this.in();
            }
            case NOTIN: {
                return this.notIn();
            }
            case STARTSWITH: {
                return this.startsWith();
            }
            case ENDSWITH: {
                return this.endsWith();
            }
            case DOESNOTSTARTWITH: {
                return this.doesNotStartWith();
            }
            case DOESNOTENDWITH: {
                return this.doesNotEndWith();
            }
        }
        throw new RuntimeException("Encountered the unsupported operator " + this.predicate.getSearchComplientOperator());
    }

    public static String getCondition(Predicate predicate) {
        FlowerConditionBuilder conditionBuilder = FlowerConditionBuilder.getConditionBuilder(predicate);
        return conditionBuilder.getCondition();
    }

    public void setSearchSchemaHelper(SearchSchemaHelper searchSchemaHelper) {
        this.searchSchemaHelper = searchSchemaHelper;
    }
}

