/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.title.search.AssetInfoProvider;
import com.tandbergtv.watchpoint.pmm.title.search.FileSearchQueryHelper;
import com.tandbergtv.watchpoint.pmm.title.search.PgAssetInfoProvider;
import com.tandbergtv.watchpoint.pmm.title.search.PgFileSearchQueryHelper;
import com.tandbergtv.watchpoint.pmm.title.search.PgTitleMetaDataConditionBuilder;
import com.tandbergtv.watchpoint.pmm.title.search.TitleMetaDataConditionBuilder;
import org.hibernate.internal.SessionFactoryImpl;

public class TitleSearchWorkFactory {
    public static boolean isOracle() {
        ApplicationContextHelper acHelper = ApplicationContextHelper.getInstance();
        return ((SessionFactoryImpl)acHelper.getSessionFactory()).getDialect().getClass().getName().contains("Oracle");
    }

    public static AssetInfoProvider createAssetInfoProvider() {
        return TitleSearchWorkFactory.isOracle() ? new AssetInfoProvider() : new PgAssetInfoProvider();
    }

    public static TitleMetaDataConditionBuilder createTitleMetaDataConditionBuilder() {
        return TitleSearchWorkFactory.isOracle() ? new TitleMetaDataConditionBuilder() : new PgTitleMetaDataConditionBuilder();
    }

    public static String getFileSearchQuery(String filePath, String providerId) {
        return TitleSearchWorkFactory.isOracle() ? FileSearchQueryHelper.getQuery(filePath, providerId) : PgFileSearchQueryHelper.getQuery(filePath, providerId);
    }

    public static String getDocumentId() {
        return TitleSearchWorkFactory.isOracle() ? "extractvalue(sys_nc_rowinfo$, '/ECMFSpec/@documentId')" : "mdm.document_id";
    }

    public static String getDocument() {
        return TitleSearchWorkFactory.isOracle() ? "xmlserialize(DOCUMENT OBJECT_VALUE AS CLOB NO INDENT)" : "xmlserialize(DOCUMENT document AS text)";
    }
}

