/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.template;

import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.Templates;
import com.tandbergtv.workflow.api.model.process.Template;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class TitleTemplateProvider
implements ITitleTemplateProvider {
    private static final Logger logger = Logger.getLogger(TitleTemplateProvider.class);

    public String getServiceName() {
        return "Title Template Provider";
    }

    public void start() {
        logger.info((Object)(this.getServiceName() + " started"));
    }

    public void stop() {
    }

    public List<String> getTemplateNamesByCategory(String category) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            for (Template template : this.getTemplateList(category)) {
                names.add(template.getName());
            }
        }
        catch (IOException e) {
            logger.warn((Object)("Failed to get templates for category: " + category), (Throwable)e);
        }
        Collections.sort(names);
        return names;
    }

    private List<Template> getTemplateList(String category) throws IOException {
        Templates request = this.request();
        request.query().category(category).count(100);
        return request.execute().getItems();
    }

    private Templates request() {
        return new API.Builder().build().templates();
    }
}

