/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.usagemonitor;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.Serializable;
import java.util.Map;

public class LicenseMonitor
implements Serializable {
    private static final long serialVersionUID = 9205625153237001373L;
    private static Map<String, Long> licenseMonitorMap;
    private static Map<String, String> licenseThresHoldMap;
    private static final String MASTER_TITLE_COUNT_KEY = "License_MasterTitleCount";
    private static final String TOKEN_USAGE_COUNT_KEY = "License_TokenUsageCount";
    private static final String MAX_TOKEN_KEY = "License_MaxToken";
    private static final String MASTER_TITLE_THRESHOLD = "License_MasterTitleThreshold";
    private static final String TOKEN_USAGE_THRESHOLD = "License_TokenUsageThreshold";
    public static final Long COMPACT_MAX_TITLE_COUNT;
    public static final Long ENTERPRISE_MAX_TITLE_COUNT;
    private static ILicenseManager licenseManager;

    private LicenseMonitor() {
        licenseMonitorMap = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH).getInstance().getMap("LicenseMonitor");
        licenseThresHoldMap = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH).getInstance().getMap("LicenseThresHold");
        licenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);
    }

    public static LicenseMonitor getInstance() {
        return LicenseMonitorHolder.licenseMonitorInstance;
    }

    public Long getMasterTitleCount() {
        return licenseMonitorMap.getOrDefault(MASTER_TITLE_COUNT_KEY, Long.MAX_VALUE);
    }

    public void setMasterTitleCount(Long masterTitleCount) {
        licenseMonitorMap.put(MASTER_TITLE_COUNT_KEY, masterTitleCount);
    }

    public Long getTokenUsage() {
        return licenseMonitorMap.getOrDefault(TOKEN_USAGE_COUNT_KEY, Long.MAX_VALUE);
    }

    public void setTokenUsage(Long tokenUsage) {
        licenseMonitorMap.put(TOKEN_USAGE_COUNT_KEY, tokenUsage);
    }

    public Long getMaxMasterTitleCount() {
        return licenseManager.isCMSCompact() ? COMPACT_MAX_TITLE_COUNT : ENTERPRISE_MAX_TITLE_COUNT;
    }

    public Long getMaxToken() {
        return licenseMonitorMap.getOrDefault(MAX_TOKEN_KEY, -1L);
    }

    public void setMaxToken(Long maxToken) {
        licenseMonitorMap.put(MAX_TOKEN_KEY, maxToken);
    }

    public void setMasterTitleThreshold(LicenseThresHold threshold) {
        licenseThresHoldMap.put(MASTER_TITLE_THRESHOLD, threshold.getThresHoldName());
    }

    public String getMasterTitleThresholdName() {
        return licenseThresHoldMap.get(MASTER_TITLE_THRESHOLD);
    }

    public void setTokenUsageThreshold(LicenseThresHold threshold) {
        licenseThresHoldMap.put(TOKEN_USAGE_THRESHOLD, threshold.getThresHoldName());
    }

    public String getTokenUsageThresholdName() {
        return licenseThresHoldMap.get(TOKEN_USAGE_THRESHOLD);
    }

    static {
        COMPACT_MAX_TITLE_COUNT = 20000L;
        ENTERPRISE_MAX_TITLE_COUNT = 0L;
    }

    public static enum LicenseThresHold {
        GOOD("Good"),
        INFORMATION("Information"),
        WARNING("Warning"),
        CRITICAL("Critical");

        private String thresHoldName;

        private LicenseThresHold(String thresHoldName) {
            this.thresHoldName = thresHoldName;
        }

        public String getThresHoldName() {
            return this.thresHoldName;
        }
    }

    private static class LicenseMonitorHolder {
        public static final LicenseMonitor licenseMonitorInstance = new LicenseMonitor();

        private LicenseMonitorHolder() {
        }
    }
}

