/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.usagemonitor;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.scheduler.QuartzSchedulerFactory;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.neptune.licensing.ILicenseChangeListener;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.watchpoint.pmm.title.license.ProcessLicensePurchaseException;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.ILicenseMonitor;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.LicenseMonitor;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.TokenCountHelper;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.TokenRenewalJob;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;

public class LicenseMonitorService
implements ILicenseMonitor,
ILicenseChangeListener {
    public static final String LICENSE_GENERATE_DATE = "LicenceGenerateDate";
    private static final String CRON_JOB_RENEW_TOKENS = "0 0 0 1 JAN ? *";
    private static final String INFORMATIONAL = "cms.usagemonitor.informational";
    private static final String WARNING = "cms.usagemonitor.warning";
    private static final String CRITICAL = "cms.usagemonitor.critical";
    private static final String SERVICE_NAME = "License Monitor";
    private static final Long MAX_LICENSE_USAGE = Long.MAX_VALUE;
    private static final String JOB_GROUP_NAME = "CMS";
    private static final String TRIGGER_GROUP_NAME = "CMS";
    private static final String TRIGGER_PREFIX = "TRIGGER_";
    private static final String JOB_TOKEN_RENEWAL = "TOKEN_RENEWAL";
    private static final Logger logger = Logger.getLogger(LicenseMonitorService.class);
    private LicenseMonitor licenseMonitor;
    private long infoThreshold;
    private long warnThreshold;
    private long criticalThreshold;
    private IClusterService hzcs;
    private IElasticSearchService esService;
    private IContentClassService contentClassService;
    private TokenCountHelper tokenCountHelper;
    private ILicenseManager neptuneLicenseManager;

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.setThresholds();
        try {
            this.activate();
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurs in LicenseMonitorService#activate().", (Throwable)e);
        }
    }

    public void stop() {
    }

    public void activate() {
        logger.info((Object)("LicenseMonitorService: activate: clusterIP:" + this.getClusterService().getLocalMember().getAddress().getHost()));
        this.registerLicenseChangeListner();
        try {
            Properties props = this.getNeptuneLicenseManager().getProperties();
            this.handleLicenseFileChange(props);
        }
        catch (InvalidLicenseException e) {
            logger.error((Object)"fail to fetch license properties", (Throwable)e);
        }
        catch (ProcessLicensePurchaseException ex) {
            logger.error((Object)"fail to handle purchase record", (Throwable)ex);
        }
        com.tandbergtv.workflow.core.service.thread.Scheduler scheduler = new com.tandbergtv.workflow.core.service.thread.Scheduler("LicenseMonitor", 1, 2);
        scheduler.start();
        int scheduleTimerForCount = this.getTokenCountHelper().getRefreshInterval();
        scheduler.schedule(() -> {
            try {
                this.recountLicense();
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurs in LicenseMonitorService#recountTitles().", (Throwable)e);
            }
        }, 0L, (long)scheduleTimerForCount);
        if (this.getClusterService().isMaster()) {
            this.scheduleRenewTokensPerYear();
        }
    }

    private void scheduleRenewTokensPerYear() {
        try {
            Scheduler quartzScheduler = QuartzSchedulerFactory.getInstance().getScheduler();
            JobDetail tokenRenewalDetail = quartzScheduler.getJobDetail(JOB_TOKEN_RENEWAL, "CMS");
            if (tokenRenewalDetail == null) {
                tokenRenewalDetail = new JobDetail(JOB_TOKEN_RENEWAL, "CMS", TokenRenewalJob.class, true, true, true);
                CronTrigger trigger = new CronTrigger("TRIGGER_TOKEN_RENEWAL", "CMS", JOB_TOKEN_RENEWAL, "CMS");
                trigger.setCronExpression(CRON_JOB_RENEW_TOKENS);
                trigger.setMisfireInstruction(1);
                trigger.setVolatility(true);
                if (quartzScheduler.isShutdown()) {
                    quartzScheduler.start();
                }
                quartzScheduler.scheduleJob(tokenRenewalDetail, (Trigger)trigger);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to checkout token renewal schedule.", (Throwable)e);
        }
    }

    private double getPercentage(long max, long current) {
        if (0L == max) {
            return 0.0;
        }
        return (double)(current * 100L) / (double)max;
    }

    void recountLicense() {
        if (!this.getClusterService().isMaster()) {
            return;
        }
        Long masterTitleCount = this.recountMasterTitle();
        Long tokenUsage = this.recountTokenUsage();
        logger.info((Object)("The master title count is : " + masterTitleCount + ", and token usage is : " + tokenUsage));
        if (masterTitleCount != null) {
            this.getLicenseMonitor().setMasterTitleCount(masterTitleCount);
        }
        if (tokenUsage != null) {
            this.getLicenseMonitor().setTokenUsage(tokenUsage);
        }
        this.checkThreshold(masterTitleCount, tokenUsage);
    }

    private void checkThreshold(Long masterTitleCount, Long tokenUsage) {
        if (masterTitleCount != null) {
            double masterTitlePercent = this.getPercentage(this.getLicenseMonitor().getMaxMasterTitleCount(), masterTitleCount);
            LicenseMonitor.LicenseThresHold masterTitleThreshold = this.getCurrentThreshold(masterTitlePercent);
            if (this.getLicenseMonitor().getMasterTitleThresholdName() == null) {
                this.getLicenseMonitor().setMasterTitleThreshold(masterTitleThreshold);
            }
            String previousMasterTitleThresholdName = this.getLicenseMonitor().getMasterTitleThresholdName();
            if (!masterTitleThreshold.getThresHoldName().equals(previousMasterTitleThresholdName)) {
                this.getLicenseMonitor().setMasterTitleThreshold(masterTitleThreshold);
                logger.info((Object)("New master title threshold detected: " + masterTitleThreshold.getThresHoldName()));
            }
        }
        if (tokenUsage != null) {
            double tokenUsagePercent = this.getPercentage(this.getLicenseMonitor().getMaxToken(), tokenUsage);
            LicenseMonitor.LicenseThresHold tokenUsageThreshold = this.getCurrentThreshold(tokenUsagePercent);
            if (this.getLicenseMonitor().getTokenUsageThresholdName() == null) {
                this.getLicenseMonitor().setTokenUsageThreshold(tokenUsageThreshold);
            }
            String previousTokenUsageThresholdName = this.getLicenseMonitor().getTokenUsageThresholdName();
            if (!tokenUsageThreshold.getThresHoldName().equals(previousTokenUsageThresholdName)) {
                this.getLicenseMonitor().setTokenUsageThreshold(tokenUsageThreshold);
                logger.info((Object)("New token usage threshold detected: " + tokenUsageThreshold.getThresHoldName()));
            }
        }
    }

    private Long recountTokenUsage() {
        try {
            return this.getTokenCountHelper().recountTokenUsage();
        }
        catch (IllegalStateException | SecurityException e) {
            logger.error((Object)"Fail to get the token usage due to inconsistent state or security problems. ", (Throwable)e);
            return MAX_LICENSE_USAGE;
        }
        catch (Exception e) {
            logger.error((Object)"Fail to get the token usage. ", (Throwable)e);
            return null;
        }
    }

    private Long recountMasterTitle() {
        try {
            return this.getMasterTitleCount();
        }
        catch (Exception e) {
            logger.error((Object)"Fail to get the master title count. ", (Throwable)e);
            return null;
        }
    }

    private LicenseMonitor.LicenseThresHold getCurrentThreshold(double percent) {
        if (percent < 0.0) {
            return LicenseMonitor.LicenseThresHold.CRITICAL;
        }
        if (percent < (double)this.infoThreshold) {
            return LicenseMonitor.LicenseThresHold.GOOD;
        }
        if (percent < (double)this.warnThreshold) {
            return LicenseMonitor.LicenseThresHold.INFORMATION;
        }
        if (percent < (double)this.criticalThreshold) {
            return LicenseMonitor.LicenseThresHold.WARNING;
        }
        return LicenseMonitor.LicenseThresHold.CRITICAL;
    }

    private long getThreshold(String key) {
        long val = 0L;
        try {
            val = Long.parseLong(this.getTokenCountHelper().getPreferences().get(key));
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurs in LicenseMonitorService#getThreshold() when parse string to long.", (Throwable)e);
        }
        return val;
    }

    void setThresholds() {
        this.infoThreshold = this.getThreshold(INFORMATIONAL);
        this.warnThreshold = this.getThreshold(WARNING);
        this.criticalThreshold = this.getThreshold(CRITICAL);
    }

    private List<String> getContentClassFilterIds(ContentClass.Type ... filters) {
        if (null == filters) {
            return new ArrayList<String>();
        }
        ArrayList<String> contentClassFilterIds = new ArrayList<String>();
        List contentClasses = null;
        try {
            contentClasses = this.getContentClassService().getAllContentClassesWithoutMetadata();
        }
        catch (ContentClassPersistenceException e) {
            logger.error((Object)"Cannot get all content classes from DB.", (Throwable)e);
        }
        if (null == contentClasses) {
            return contentClassFilterIds;
        }
        for (ContentClass.Type filter : filters) {
            for (ContentClass cc : contentClasses) {
                if (filter != cc.getType()) continue;
                contentClassFilterIds.add(String.valueOf(cc.getId()));
            }
        }
        return contentClassFilterIds;
    }

    private ExpValue getTitleContentClassTypeCriteria() {
        PredicateRightValue predicate = new PredicateRightValue();
        predicate.setFieldLeft("contentClassId");
        predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
        predicate.setDataType("integer");
        predicate.setOperator(LogicalOperator.IN);
        predicate.setNot(Boolean.valueOf(true));
        predicate.setValue(this.getContentClassFilterIds(LicenseFilter.CONTENT_CLASS_FILTER));
        return new ExpValue((Predicate)predicate);
    }

    private PredicateRightValue buildTitleStatusPredicate(TitleStatus ... statuses) {
        PredicateRightValue predicate = new PredicateRightValue();
        predicate.setFieldLeft("status");
        predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
        predicate.setDataType("string");
        predicate.setOperator(LogicalOperator.IN);
        if (null == statuses) {
            predicate.setValue(new ArrayList());
        } else {
            for (TitleStatus ts : statuses) {
                predicate.addValue(ts.name());
            }
        }
        return predicate;
    }

    private ExpValue getMasterTitleStatusCriteria() {
        return new ExpValue((Predicate)this.buildTitleStatusPredicate(TitleStatus.DRAFT, TitleStatus.COMMITTED, TitleStatus.READY, TitleStatus.APPROVED, TitleStatus.PLANNED));
    }

    private TitleFilter getMasterTitleFilter() {
        ExpList rootNode = new ExpList();
        rootNode.addItem((ExpNode)this.getMasterTitleStatusCriteria());
        rootNode.addItem((ExpNode)this.getTitleContentClassTypeCriteria());
        return new TitleFilter((ExpNode)rootNode);
    }

    private long getTitleCount(TitleFilter filter, ElasticSearchIndexType ... types) throws Exception {
        if (null == types) {
            return 0L;
        }
        long val = 0L;
        SearchParameters params = new SearchParameters();
        for (ElasticSearchIndexType type : types) {
            params.setTitleIndexType(type);
            val += this.getElasticSearchService().getTitleCount(filter.getRootNode(), params);
        }
        return val;
    }

    private long getMasterTitleCount() throws Exception {
        return this.getTitleCount(this.getMasterTitleFilter(), ElasticSearchIndexType.MASTER, ElasticSearchIndexType.SERIES);
    }

    private LicenseMonitor getLicenseMonitor() {
        if (this.licenseMonitor == null) {
            this.licenseMonitor = LicenseMonitor.getInstance();
        }
        return this.licenseMonitor;
    }

    private IClusterService getClusterService() {
        if (this.hzcs == null) {
            this.hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
        }
        return this.hzcs;
    }

    private IElasticSearchService getElasticSearchService() {
        if (this.esService == null) {
            this.esService = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
        }
        return this.esService;
    }

    private IContentClassService getContentClassService() {
        if (this.contentClassService == null) {
            this.contentClassService = (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
        }
        return this.contentClassService;
    }

    private ILicenseManager getNeptuneLicenseManager() {
        if (this.neptuneLicenseManager == null) {
            this.neptuneLicenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);
        }
        return this.neptuneLicenseManager;
    }

    public void registerLicenseChangeListner() {
        this.getNeptuneLicenseManager().addLicenseChangeListener((ILicenseChangeListener)this);
    }

    public void handleLicenseFileChange(Properties pros) {
        if (!this.hzcs.isMaster()) {
            return;
        }
        if (null != pros.get(LICENSE_GENERATE_DATE)) {
            logger.info((Object)"license file updated with token");
            Long totalTokenNum = -1L;
            try {
                totalTokenNum = Long.parseLong(pros.getProperty("tokens"));
            }
            catch (Exception e) {
                throw new ProcessLicensePurchaseException("Exception is thrown when handling purchase record.", e);
            }
            Long totalTokenNumCache = this.getLicenseMonitor().getMaxToken();
            if (!totalTokenNumCache.equals(totalTokenNum)) {
                this.getLicenseMonitor().setMaxToken(totalTokenNum);
                logger.info((Object)"total token number is updated");
            }
        }
    }

    private TokenCountHelper getTokenCountHelper() {
        if (this.tokenCountHelper == null) {
            this.tokenCountHelper = TokenCountHelper.getInstance();
        }
        return this.tokenCountHelper;
    }
}

