/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.usagemonitor;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.GlobalDateFormatUtil;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.TokenUsage;
import com.tandbergtv.watchpoint.pmm.util.AESEncrytionDecrytionUtil;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class TokenCountHelper {
    private static final Logger logger = Logger.getLogger(TokenCountHelper.class);
    private static final Long TOKEN_USAGE_ID = 1L;
    private static final String INITIAL_TOKEN_USAGE_VALUE = "0";
    private static final Long MAX_QUERY_TIME_INTERVAL_IN_DAYS = 1L;
    public static final String TITLE_INCREMNT_SQL = "select count(*) from pmm_title t where t.createDate > cast(to_timestamp( :lastQueryTime / 1000) as timestamp without time zone) and t.createDate <= cast(to_timestamp( :currentTime / 1000) as timestamp without time zone) and t.originaltitle_id is null and content_class_id != :offerId";
    public static final String TITLE_LAST_MODIFIED_TIME_SQL_WITH_PARAM = "select last_modified_time from pmm_title where last_modified_time <=(now()-interval 'REFRESH_TIME_VALUE milliseconds') order by last_modified_time desc limit 1";
    public static final String TOKEN_TIME_DELIMITER = "-";
    public static final String VALIDATE_TOKEN_ERROR_MSG = "Token usage is in an inconsistent state. Token last update time(%s) is %d days ago, but title last update time(%s) is later than that.";
    public static final String VALIDATE_TOKEN_QUERY_ERROR_MSG = "Token usage is in an inconsistent state. Token last update time: %s, BUT now(%s) is earlier than that.";
    private Long offerContentClassId;
    private IContentClassService contentClassService;
    private Map<String, String> preferences;

    private TokenCountHelper() {
    }

    public static TokenCountHelper getInstance() {
        return TokenCountHelperHolder.tokenCountHelperInstance;
    }

    @Transactional
    public Long recountTokenUsage() {
        Long lastQueryTime;
        Long usedTokenCount;
        TokenUsage tokenUsage = this.getTokenUsage();
        String decryptedTokenUsage = AESEncrytionDecrytionUtil.decrypt(tokenUsage.getEncryptedTokenUsage());
        if (INITIAL_TOKEN_USAGE_VALUE.equals(decryptedTokenUsage)) {
            usedTokenCount = 0L;
            lastQueryTime = this.getFirstDayOfYear();
        } else {
            String[] tokenAndLastQueryTime = decryptedTokenUsage.split(TOKEN_TIME_DELIMITER);
            usedTokenCount = Long.valueOf(tokenAndLastQueryTime[0]);
            lastQueryTime = Long.valueOf(tokenAndLastQueryTime[1]);
        }
        Long currentTime = System.currentTimeMillis();
        usedTokenCount = usedTokenCount + this.getTitleIncrement(lastQueryTime, currentTime);
        this.updateTokenUsage(usedTokenCount, currentTime);
        HibernateContext.getContext().getCurrentSession().flush();
        return usedTokenCount;
    }

    public Map<String, String> getPreferences() {
        if (this.preferences == null) {
            IConfigurationService configurationService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
            this.preferences = configurationService.getProperties("com.ericsson.cms.usagemonitor");
        }
        return this.preferences;
    }

    public int getRefreshInterval() {
        return NumberUtils.toInt((String)this.getPreferences().get("cms.usagemonitor.refreshTime"));
    }

    @Transactional
    public void cleanupTokenUsage() {
        this.updateTokenUsage(0L, System.currentTimeMillis());
        HibernateContext.getContext().getCurrentSession().flush();
        logger.info((Object)"REMINDER: Token usage has been reset to 0 in new year.");
    }

    private void updateTokenUsage(Long usedTokenCount, Long lastQueryTime) {
        TokenUsage tokenUsage = (TokenUsage)HibernateContext.getContext().getCurrentSession().get(TokenUsage.class, (Serializable)TOKEN_USAGE_ID);
        this.validateTokenUsage(tokenUsage);
        tokenUsage.setEncryptedTokenUsage(this.generateTokenUsageValue(usedTokenCount, lastQueryTime));
    }

    private Long getTitleIncrement(Long lastQueryTime, Long currentTime) {
        Session session = HibernateContext.getContext().getCurrentSession();
        NativeQuery titleIncrementQuery = session.createSQLQuery(TITLE_INCREMNT_SQL);
        titleIncrementQuery.setLong("lastQueryTime", lastQueryTime.longValue());
        titleIncrementQuery.setLong("currentTime", currentTime.longValue());
        titleIncrementQuery.setLong("offerId", this.getOfferContentClassId().longValue());
        return ((Number)titleIncrementQuery.uniqueResult()).longValue();
    }

    private TokenUsage getTokenUsage() {
        TokenUsage dbTokenUsage = (TokenUsage)HibernateContext.getContext().getCurrentSession().get(TokenUsage.class, (Serializable)TOKEN_USAGE_ID);
        this.validateTokenUsage(dbTokenUsage);
        return dbTokenUsage;
    }

    private Timestamp getTitleLastModifiedTime() {
        String sql = TITLE_LAST_MODIFIED_TIME_SQL_WITH_PARAM.replace("REFRESH_TIME_VALUE", String.valueOf(this.getRefreshInterval()));
        Session session = HibernateContext.getContext().getCurrentSession();
        NativeQuery query = session.createSQLQuery(sql);
        Timestamp lastModifiedTime = null;
        if (query.uniqueResult() != null) {
            lastModifiedTime = (Timestamp)query.uniqueResult();
        }
        return lastModifiedTime;
    }

    private void validateTokenUsage(TokenUsage t) {
        if (t == null) {
            throw new IllegalStateException("The token usage record not found in database!");
        }
        String decryptedTokenUsage = AESEncrytionDecrytionUtil.decrypt(t.getEncryptedTokenUsage());
        if (INITIAL_TOKEN_USAGE_VALUE.equals(decryptedTokenUsage)) {
            return;
        }
        this.checkTokenUsageAfterInitialization(decryptedTokenUsage);
    }

    private void checkTokenUsageAfterInitialization(String decryptedTokenUsage) {
        Long lastQueryTimeInDB = Long.valueOf(decryptedTokenUsage.split(TOKEN_TIME_DELIMITER)[1]);
        long currentTime = System.currentTimeMillis();
        if (currentTime < lastQueryTimeInDB) {
            throw new IllegalStateException(String.format(VALIDATE_TOKEN_QUERY_ERROR_MSG, GlobalDateFormatUtil.formatDateTime((Date)new Date(lastQueryTimeInDB)), GlobalDateFormatUtil.formatDateTime((Date)new Date(currentTime))));
        }
        long licenseUsageNotUpdatedDays = TimeUnit.DAYS.convert(currentTime - lastQueryTimeInDB, TimeUnit.MILLISECONDS);
        if (licenseUsageNotUpdatedDays > MAX_QUERY_TIME_INTERVAL_IN_DAYS) {
            Timestamp titleLastModifiedTime = this.getTitleLastModifiedTime();
            if (titleLastModifiedTime == null) {
                return;
            }
            if (titleLastModifiedTime.getTime() - lastQueryTimeInDB <= TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)) {
                return;
            }
            throw new IllegalStateException(String.format(VALIDATE_TOKEN_ERROR_MSG, GlobalDateFormatUtil.formatDateTime((Date)new Date(lastQueryTimeInDB)), licenseUsageNotUpdatedDays, GlobalDateFormatUtil.formatDateTime((LocalDateTime)titleLastModifiedTime.toLocalDateTime())));
        }
    }

    private Long getFirstDayOfYear() {
        return LocalDate.now().with(TemporalAdjusters.firstDayOfYear()).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    private String generateTokenUsageValue(Long usedTokenCount, Long lastQueryTime) {
        return AESEncrytionDecrytionUtil.encrypt(String.join((CharSequence)TOKEN_TIME_DELIMITER, String.valueOf(usedTokenCount), String.valueOf(lastQueryTime)));
    }

    private Long getOfferContentClassId() {
        if (this.offerContentClassId == null) {
            try {
                this.offerContentClassId = this.getContentClassService().getOfferContentClassId();
            }
            catch (ContentClassPersistenceException e) {
                logger.error((Object)"fail to get the offer ContentClassId", (Throwable)e);
                this.offerContentClassId = 0L;
            }
        }
        return this.offerContentClassId;
    }

    private IContentClassService getContentClassService() {
        if (this.contentClassService == null) {
            this.contentClassService = (IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class);
        }
        return this.contentClassService;
    }

    static class TokenCountHelperHolder {
        public static final TokenCountHelper tokenCountHelperInstance = new TokenCountHelper();

        private TokenCountHelperHolder() {
        }
    }
}

