/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class AuthConfigHelper {
    private static final String PACKAGE_NAME = "com/tandbergtv/watchpoint/pmm/util/";
    private static final String TMP_AUTH_CONFIG_FILE = "pmm-auth.xml";
    private static final String AUTH_CONFIG_FILE = "auth.xml";

    private AuthConfigHelper() {
    }

    private static File getTempFile() {
        return new File(System.getProperty("java.io.tmpdir") + File.separator + TMP_AUTH_CONFIG_FILE);
    }

    public static File getAuthConfigFile() {
        File file = AuthConfigHelper.getTempFile();
        if (file.exists()) {
            return file;
        }
        try (InputStream is = AuthConfigHelper.class.getClassLoader().getResourceAsStream("com/tandbergtv/watchpoint/pmm/util/auth.xml");
             FileOutputStream fos = new FileOutputStream(file);){
            int read;
            byte[] buf = new byte[4096];
            while ((read = is.read(buf)) > 0) {
                fos.write(buf, 0, read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    static {
        File file = AuthConfigHelper.getTempFile();
        if (file.exists()) {
            file.delete();
        }
    }
}

