/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class TableConfigHelper {
    private static final Logger logger = Logger.getLogger(TableConfigHelper.class);
    private static final String PACKAGE_NAME = "com/tandbergtv/watchpoint/pmm/util/";
    private static final String TMP_TABLE_CONFIG_FILE = "pmm-table-config.xml";
    private static final String TABLE_CONFIG_FILE = "table-config.xml";
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String PMM_CONFIG_DIR = "pmm";
    static final Set<String> REFRESHED_FILES = new HashSet<String>();

    private TableConfigHelper() {
    }

    public static File getTempFile(String tempFileName, InputStream in) {
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + tempFileName);
        boolean fileExists = file.exists();
        if (fileExists && TableConfigHelper.fileRefreshed(tempFileName)) {
            return file;
        }
        if (fileExists) {
            FileUtils.deleteQuietly((File)file);
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            logger.error((Object)("fail to create temp file " + file.getAbsolutePath()), (Throwable)e);
            throw new UncheckedIOException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            REFRESHED_FILES.add(tempFileName);
        }
        return file;
    }

    private static boolean fileRefreshed(String tempFileName) {
        return REFRESHED_FILES.contains(tempFileName);
    }

    public static File getTableConfigFile() {
        String dir = System.getProperty(PRODUCT_DIR) + File.separator + "conf";
        String filename = dir + File.separator + PMM_CONFIG_DIR + File.separator + TABLE_CONFIG_FILE;
        File file = new File(filename);
        if (file.exists()) {
            return file;
        }
        return TableConfigHelper.getTempFile(TMP_TABLE_CONFIG_FILE, TableConfigHelper.class.getClassLoader().getResourceAsStream("com/tandbergtv/watchpoint/pmm/util/table-config.xml"));
    }
}

