/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.messageidentifier;

import com.tandbergtv.workflow.adaptor.AdaptorRuntimeException;
import com.tandbergtv.workflow.adaptor.messageidentifier.IMessageIdentifier;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.util.WPCLValidationException;
import com.tandbergtv.workflow.message.util.WPCLValidator;
import com.tandbergtv.workflow.message.util.XMLDocumentUtility;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WPCLMessageIdentifier
implements IMessageIdentifier {
    private static final Logger LOGGER = Logger.getLogger(WPCLMessageIdentifier.class);

    @Override
    public IMessageUID identify(IMessage message) {
        IMessageUID uid = null;
        try {
            LOGGER.debug((Object)("Attempting to identify message: " + message.getPayload()));
            String payload = message.getPayload().getContent();
            Document doc = XMLDocumentUtility.loadXml((String)payload, (boolean)true);
            WPCLValidator.newInstance().validate(doc);
            uid = this.getUIDFromWPCL(doc);
        }
        catch (WPCLValidationException e) {
            throw new AdaptorRuntimeException("Message is not in WPCL format", e);
        }
        catch (Exception e) {
            throw new AdaptorRuntimeException(e);
        }
        return uid;
    }

    private IMessageUID getUIDFromWPCL(Document doc) throws XPathExpressionException {
        NodeList nodes = doc.getElementsByTagName("WFSMessage");
        Element e = (Element)nodes.item(0);
        String uid = e.getAttribute("UID");
        LOGGER.debug((Object)("Message identified having uid:" + uid));
        return new MessageUIDImpl(uid);
    }
}

