/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.boot;

import com.ericsson.neptune.configuration.settings.client.NeptuneServiceLocator;
import com.tandbergtv.workflow.adaptor.IAdaptorService;
import com.tandbergtv.workflow.adaptor.internal.AdaptorService;
import com.tandbergtv.workflow.core.lifecycle.Platform;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import com.tandbergtv.workflow.core.settings.SettingsPluginLoader;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.WatchPointPluginManager;
import com.tandbergtv.workflow.web.neptune.ServicePropertyFileLoader;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.java.plugin.PluginManager;

public class Activator {
    private static final String SETTING_GROUP = "com.tandbergtv.workflow.application";
    private static final String RETRY_SETTING_INTERVAL = "adaptor.retry.interval";
    private static final String RETRY_SETTING_MAX = "adaptor.retry.max";
    private static final Logger LOGGER = Logger.getLogger(Activator.class);

    public void start() {
        PluginManager pluginManager = Platform.getPlatform().getPluginManager();
        this.addService((Service)new WatchPointPluginManager(pluginManager, Integer.MAX_VALUE));
        String retryInterval = null;
        String retryCount = null;
        NeptuneServiceLocator.setProp((Properties)ServicePropertyFileLoader.getProperties());
        ISettingsProvider settingsProvider = new SettingsPluginLoader().createSettingsProvider();
        if (settingsProvider != null) {
            Map<String, String> settings = settingsProvider.getProperties(SETTING_GROUP);
            retryInterval = settings.get(RETRY_SETTING_INTERVAL);
            retryCount = settings.get(RETRY_SETTING_MAX);
        }
        this.addService(new AdaptorService(retryInterval, retryCount));
    }

    public void stop() {
        this.removeService(IAdaptorService.class);
        this.removeService(PluginManagement.class);
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }
}

