/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.comm.routing.impl;

import com.tandbergtv.workflow.adaptor.AdaptorRequestImpl;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.IAdaptorService;
import com.tandbergtv.workflow.adaptor.registry.IAdaptorRegistry;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.routing.CommunicationException;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.impl.WorkflowMessageConvertor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.ICommandExecutor;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import java.util.List;
import org.apache.log4j.Logger;

public class Router
implements IRoutingService {
    private static final Logger LOGGER = Logger.getLogger(Router.class);

    public IMessage send(IMessage message) throws CommunicationException {
        LOGGER.debug((Object)("Request " + message));
        MessageImpl ret = null;
        ICommandExecutor executor = (ICommandExecutor)ServiceRegistry.getDefault().lookup(ICommandExecutor.class);
        try {
            WorkflowMessage request = new WorkflowMessageConvertor().toWorkflowMessage(message);
            WorkflowMessage response = executor.execute(request);
            LOGGER.debug((Object)("Response " + response));
            ret = new WorkflowMessageConvertor().toGenericMessage(response);
        }
        catch (Exception e) {
            throw new CommunicationException(e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    public WorkflowMessage send(WorkflowMessage message, List<IDestination> destinations) throws CommunicationException {
        if (destinations == null || destinations.isEmpty()) {
            throw new CommunicationException("At least one destination must be specified");
        }
        LOGGER.debug((Object)("Request " + message));
        WorkflowMessage ret = null;
        try {
            String deviceId = this.getMessageDeviceID(message);
            MessageImpl request = new WorkflowMessageConvertor().toGenericMessage(message);
            AdaptorRequestImpl adaptorRequest = new AdaptorRequestImpl((IMessage)request, message.getSource(), destinations);
            IAdaptorRegistry registry = ((IAdaptorService)ServiceRegistry.getDefault().lookup(IAdaptorService.class)).getRegistry();
            IAdaptor adaptor = registry.getDeviceAdaptor(deviceId);
            if (adaptor == null) {
                throw new CommunicationException("No adaptor registered for systemID[" + deviceId + "]");
            }
            IAdaptorResponse response = adaptor.transmit((IAdaptorRequest)adaptorRequest);
            ret = new WorkflowMessageConvertor().toWorkflowMessage(response.getMessage());
            LOGGER.debug((Object)("Response: " + ret));
        }
        catch (CommunicationException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new CommunicationException(ex.getMessage(), (Throwable)ex);
        }
        return ret;
    }

    private String getMessageDeviceID(WorkflowMessage message) throws CommunicationException {
        String uid = message.getMessageUID().getUID();
        String deviceId = this.getMessageRegistry().getMessageDeviceID(uid);
        if (deviceId == null) {
            throw new CommunicationException("No message found in registry for UID[" + uid + "]");
        }
        return deviceId;
    }

    private IMessageRegistry getMessageRegistry() {
        return ((IAdaptorService)ServiceRegistry.getDefault().lookup(IAdaptorService.class)).getMessageRegistry();
    }
}

