/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.tandbergtv.workflow.driver.message.queue.IFileMessageConsumer;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.producer.MessageConvertor;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.XMLDocumentUtility;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class FileMessageReader {
    private static final Logger LOGGER = Logger.getLogger(FileMessageReader.class);
    public static final String FAIL_TO_PARSE = "Failed to parse the WPCL message.";

    public long scan(IFileMessageConsumer consumer) {
        List<File> files = this.scan(consumer.getWorkDir());
        long handeledNumber = 0L;
        if (!files.isEmpty()) {
            handeledNumber = consumer.handle(files);
        }
        return handeledNumber;
    }

    public List<File> scan(String workDir) {
        File directory = new File(workDir);
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File f, String name) {
                return name.endsWith(".xml");
            }
        });
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    public WorkflowMessage readMessage(File file) throws MarshalException {
        Document document = null;
        try {
            document = this.getDOM(file);
        }
        catch (SAXException e) {
            LOGGER.debug((Object)"Failed to read file:", (Throwable)e);
        }
        if (document == null && this.verifyTheFileReadyToRead(file)) {
            try {
                document = this.getDOM(file);
            }
            catch (SAXException e) {
                throw new MarshalException(FAIL_TO_PARSE, (Throwable)e);
            }
        }
        return document != null ? new MessageConvertor().asWorkflowMessage(document) : null;
    }

    private Document getDOM(File file) throws SAXException {
        try {
            return XMLDocumentUtility.loadFile((File)file);
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Failed to read the message on " + file.getAbsolutePath()), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyTheFileReadyToRead(File file) {
        String testFilePath = "/tmp/" + file.getName() + "." + System.currentTimeMillis() + ".tmp";
        try {
            FileUtils.copyFile((File)file, (File)new File(testFilePath));
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.deleteQuietly((File)new File(testFilePath));
        }
        return true;
    }
}

