/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.ericsson.cms.neptune.rabbitmq.factory.MQServiceFactory;
import com.ericsson.cms.neptune.rabbitmq.service.IRabbitMQService;
import com.ericsson.cms.neptune.rabbitmq.util.MQPropertyLoader;
import com.ericsson.cms.neptune.rabbitmq.workflow.WorkflowExchangeType;
import com.ericsson.cms.neptune.rabbitmq.workflow.WorkflowQueueType;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.internal.PersistenceServiceFactory;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.internal.WorkflowProcessDTOService;
import com.tandbergtv.workflow.driver.message.queue.IMessageProcessor;
import com.tandbergtv.workflow.driver.message.queue.IQueueInfo;
import com.tandbergtv.workflow.driver.message.queue.MessageProcessorImpl;
import com.tandbergtv.workflow.driver.message.queue.MessageReceiver;
import com.tandbergtv.workflow.driver.message.queue.RabbitMQQueueMonitorProvider;
import com.tandbergtv.workflow.driver.message.queue.WorkOrderMessageConsumer;
import com.tandbergtv.workflow.message.command.ICreateIdFeature;
import com.tandbergtv.workflow.message.command.internal.CommandExecutor;
import com.tandbergtv.workflow.message.command.internal.CreateIDCommandExecutorStrategy;
import com.tandbergtv.workflow.message.command.internal.CreateIdFeatureDBImpl;
import com.tandbergtv.workflow.message.producer.IMessageProducer;
import com.tandbergtv.workflow.message.producer.MessageConvertor;
import org.hibernate.SessionFactory;

public class MessageQueueFactory {
    public static final WorkflowExchangeType DEFAULT_WO_EXCHANGE = WorkflowExchangeType.COMPLETION;
    public static final WorkflowQueueType DEFAULT_WO_QUEUE = WorkflowQueueType.COMPLETION;

    private static MessageConvertor createMessageConvertor() {
        return new MessageConvertor();
    }

    public static IMessageProducer lookupMessageProducer() {
        return (IMessageProducer)ServiceRegistry.getDefault().lookup(IMessageProducer.class);
    }

    private static IRabbitMQService createRabbitMQService() {
        return MQServiceFactory.createRabbitMQService();
    }

    public static WorkOrderMessageConsumer createMessageConsumer(CommandExecutor cmdExecutor, SessionFactory factory) {
        return MessageQueueFactory.createMessageConsumer(MessageQueueFactory.createRabbitMQService(), cmdExecutor, factory);
    }

    public static WorkOrderMessageConsumer createMessageConsumer(IRabbitMQService mqService, CommandExecutor cmdExecutor, SessionFactory factory) {
        IMessageProcessor processor = MessageQueueFactory.createMessageProcessor(cmdExecutor, factory);
        MessageReceiver messageReceiver = MessageQueueFactory.createMessageReceiver(mqService);
        WorkOrderMessageConsumer defaultMessageConsumer = new WorkOrderMessageConsumer();
        defaultMessageConsumer.setProcessor(processor);
        defaultMessageConsumer.setMessageReceiver(messageReceiver);
        defaultMessageConsumer.setRateLimiter(ServiceLookup.lookupRateLimiter());
        defaultMessageConsumer.setActiveWorkOrderMonitor(ServiceLookup.lookupActiveWOMonitor());
        defaultMessageConsumer.setMessageConvertor(MessageQueueFactory.createMessageConvertor());
        IQueueInfo queueInfo = (IQueueInfo)new RabbitMQQueueMonitorProvider().createMonitor();
        defaultMessageConsumer.setQueueInfor(queueInfo);
        return defaultMessageConsumer;
    }

    private static MessageReceiver createMessageReceiver(IRabbitMQService mqService) {
        MQPropertyLoader loader = MQServiceFactory.createMQPropertyLoader();
        int qos = loader.getConsumerQoS(10);
        return new MessageReceiver(mqService, qos);
    }

    private static IMessageProcessor createMessageProcessor(CommandExecutor cmdExecutor, SessionFactory factory) {
        return new MessageProcessorImpl(cmdExecutor, MessageQueueFactory.createCommandExecutorStrategy(factory));
    }

    private static CreateIDCommandExecutorStrategy createCommandExecutorStrategy(SessionFactory factory) {
        return new CreateIDCommandExecutorStrategy(MessageQueueFactory.createCreateIDFeature(factory));
    }

    private static ICreateIdFeature createCreateIDFeature(SessionFactory factory) {
        WorkflowProcessDTOService processDtoService = PersistenceServiceFactory.createProcessDtoService((SessionFactory)factory);
        return new CreateIdFeatureDBImpl(processDtoService);
    }
}

