/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.tandbergtv.workflow.core.queue.monitor.IQueueMonitor;
import com.tandbergtv.workflow.core.queue.provider.IQueueProvider;
import com.tandbergtv.workflow.driver.internal.monitor.IMetricUnit;
import com.tandbergtv.workflow.driver.internal.monitor.MetricInfoType;
import com.tandbergtv.workflow.driver.internal.monitor.MetricLogger;
import com.tandbergtv.workflow.driver.internal.monitor.ScheduledMetricLogWriter;
import com.tandbergtv.workflow.driver.message.queue.WorkflowMessageQueueInfo;
import com.tandbergtv.workflow.message.WorkflowMessage;

public class RabbitMQQueueMonitorProvider
implements IQueueProvider<WorkflowMessage> {
    private static final String METRIC_TYPE_NAME = "queue_info";

    public IQueueMonitor createMonitor() {
        final WorkflowMessageQueueInfo queueInfo = new WorkflowMessageQueueInfo();
        ScheduledMetricLogWriter.getInstance().addMetricUnit(new IMetricUnit(){

            public void write(MetricLogger logWriter) {
                logWriter.writeLog(MetricInfoType.QUEUE_SIZE, queueInfo.getSize());
                logWriter.writeLog(MetricInfoType.MAX_QUEUE_SIZE, queueInfo.getMaxSize());
            }

            public boolean onlyWriteInMasterNode() {
                return true;
            }

            public String getMetricName() {
                return RabbitMQQueueMonitorProvider.METRIC_TYPE_NAME;
            }
        });
        return queueInfo;
    }
}

