/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.google.common.base.Function;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.graph.ExtendedNodeLog;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.entities.ProcessQueuedPerResourceLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.SearchHit;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;

public class LogDeserializer {
    public static List<ProcessLog> convert(SearchHit[] hits) {
        if (hits == null) {
            throw new IllegalArgumentException("SearchHits is null");
        }
        ArrayList<ProcessLog> processLogs = new ArrayList<ProcessLog>();
        for (SearchHit hit : hits) {
            Map logMap = hit.getSourceAsMap();
            if (logMap == null) {
                throw new NullPointerException("SearchHit Source is null");
            }
            if (logMap.get("logType").equals("messageLog")) {
                processLogs.add((ProcessLog)LogDeserializer.forMessageLog().apply((Object)logMap));
                continue;
            }
            if (logMap.get("logType").equals("resourceLog")) {
                processLogs.add((ProcessLog)LogDeserializer.forResourceLog().apply((Object)logMap));
                continue;
            }
            if (!logMap.get("logType").equals("nodeLog")) continue;
            processLogs.add((ProcessLog)LogDeserializer.forNodeLog().apply((Object)logMap));
        }
        return processLogs;
    }

    public static Function<Map<String, Object>, NodeLog> forNodeLog() {
        return new Function<Map<String, Object>, NodeLog>(){

            public NodeLog apply(Map<String, Object> map) {
                Long id = (Long)map.get("id");
                Long startTime = (Long)map.get("startTime");
                Long endTime = (Long)map.get("endTime");
                Integer nodeId = (Integer)map.get("nodeId");
                Node node = new Node(String.valueOf(nodeId));
                Long subprocessId = LogDeserializer.parseLong(map, "subprocessId");
                NodeLog log = this.createNodeLog(startTime, endTime, node, subprocessId);
                LogDeserializer.setId((ProcessLog)log, id);
                log.setToken(LogDeserializer.getToken(LogDeserializer.parseLong(map, "tokenId")));
                return log;
            }

            private NodeLog createNodeLog(Long startTime, Long endTime, Node node, Long subprocessId) {
                return new ExtendedNodeLog(subprocessId.longValue(), node, new Date(startTime), new Date(endTime));
            }
        };
    }

    public static Function<Map<String, Object>, MessageLog> forMessageLog() {
        return new Function<Map<String, Object>, MessageLog>(){

            public MessageLog apply(Map<String, Object> map) {
                WorkflowMessageLog log = new WorkflowMessageLog();
                log.setMessageUID((String)map.get("messageUID"));
                log.setMessageType((String)map.get("messageType"));
                log.setMessageName((String)map.get("messageName"));
                log.setMessage((String)map.get("message"));
                log.setIncoming((Boolean)map.get("incoming"));
                log.setTimestamp(new Date((Long)map.get("timestamp")));
                log.setResource(map.get("resourceId") != null && !"".equals(map.get("resourceId")) ? new Resource(new Long(map.get("resourceId").toString()).longValue()) : null);
                log.setNode(new Node(map.get("nodeId").toString()));
                log.setToken(LogDeserializer.getToken(LogDeserializer.parseLong(map, "tokenId")));
                log.setId((Long)map.get("id"));
                return new MessageLog(log);
            }
        };
    }

    public static Function<Map<String, Object>, ProcessStatusPerResourceLog> forResourceLog() {
        return new Function<Map<String, Object>, ProcessStatusPerResourceLog>(){

            public ProcessStatusPerResourceLog apply(Map<String, Object> map) {
                ProcessStatusPerResourceLog log = null;
                log = map.get("queued") != null && Boolean.TRUE.equals(map.get("queued")) ? new ProcessQueuedPerResourceLog() : new ProcessStatusPerResourceLog();
                if (LogDeserializer.hasField(map, "tokenId")) {
                    log.setTokenId(LogDeserializer.parseLong(map, "tokenId"));
                }
                log.setNodeId(LogDeserializer.parseLong(map, "nodeId"));
                log.setResourceGroupId(LogDeserializer.parseLong(map, "resourceGroupId"));
                log.setResourceId(LogDeserializer.parseLong(map, "resourceId"));
                log.setStartTime(LogDeserializer.parseDate(map, "startTime"));
                log.setEndTime(LogDeserializer.parseDate(map, "endTime"));
                log.setOperationalStatus(ProcessStatus.valueOf((String)((String)map.get("operationalStatus"))));
                log.setAdminStatus(ProcessStatus.valueOf((String)((String)map.get("adminStatus"))));
                if (LogDeserializer.hasField(map, "id")) {
                    LogDeserializer.setId(log, LogDeserializer.parseLong(map, "id"));
                } else {
                    LogDeserializer.setId(log, LogDeserializer.parseLong(map, "endTime"));
                }
                return log;
            }
        };
    }

    private static Long parseLong(Map<String, Object> fields, String field) {
        return Configuration.toLong((Object)fields.get(field), (long)-1L);
    }

    private static Token getToken(long id) {
        Token token = new Token();
        try {
            Field field = token.getClass().getDeclaredField("id");
            field.setAccessible(true);
            field.set(token, id);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        return token;
    }

    private static void setId(ProcessLog processLog, Long value) {
        try {
            Field field = ProcessLog.class.getDeclaredField("id");
            field.setAccessible(true);
            field.set(processLog, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean hasField(Map<String, Object> fields, String field) {
        return fields.containsKey(field);
    }

    private static Date parseDate(Map<String, Object> fields, String field) {
        return new Date(LogDeserializer.parseLong(fields, field));
    }
}

