/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.tandbergtv.workflow.log.Finder;
import com.tandbergtv.workflow.log.file.Directories;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class FileLogsGarbageCollector
implements Runnable {
    private int window;
    private String dir;
    private Finder finder;
    private static final Logger LOGGER = Logger.getLogger(FileLogsGarbageCollector.class);

    public FileLogsGarbageCollector(String dir, int window, Finder finder) {
        this.dir = dir;
        this.window = window;
        this.finder = finder;
    }

    @Override
    public void run() {
        Date date = this.getCutoffDate();
        try {
            Collection<String> directories = this.findDirectories(date);
            long t = System.currentTimeMillis();
            for (String directory : directories) {
                File file = new File(directory);
                if (!file.exists()) continue;
                LOGGER.debug((Object)("Deleting " + directory));
                Directories.delete(file);
            }
            LOGGER.debug((Object)("Elapsed time: " + (System.currentTimeMillis() - t) / 1000L + "s"));
        }
        catch (Throwable e) {
            LOGGER.error((Object)":(", e);
        }
    }

    private Collection<String> findDirectories(Date date) {
        long id = this.finder.findBefore(date);
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        if (id > 0L) {
            LOGGER.debug((Object)("ID " + id + " " + this.formatDate(date)));
            File parent = this.parentDirectoryOf(id);
            if (parent != null) {
                long startIndex = Long.valueOf(parent.getName()) - 1L;
                String root = parent.getParent() + File.separator;
                for (long i = startIndex; i > 0L; --i) {
                    files.add(root + i);
                }
            }
        }
        return files;
    }

    private File parentDirectoryOf(long id) {
        File file = new File(Directories.pathFor(this.dir, id));
        if (file.exists()) {
            return file.getParentFile();
        }
        return null;
    }

    private Date getCutoffDate() {
        return new Date(System.currentTimeMillis() - (long)(this.window * 86400 * 1000));
    }

    private String formatDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm").format(date);
    }
}

