/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.settings;

import com.ericsson.cms.neptune.rabbitmq.service.IRabbitMQService;
import com.google.common.collect.Lists;
import com.rabbitmq.client.AlreadyClosedException;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.message.producer.ComponentType;
import com.tandbergtv.workflow.message.producer.IMQExchangeBindingService;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MQExchangeBindingService
implements IMQExchangeBindingService,
Service {
    private static final Logger LOGGER = Logger.getLogger(MQExchangeBindingService.class);
    private static final String EXCHANGE_BINDING_SERVICE = "RabbitMQ-Exchange-Binding";
    private List<String> byPassFilters = new ArrayList<String>();
    private volatile boolean bindingInited = false;
    private IRabbitMQService rabbitMQService;
    private Scheduler<Void> scheduler;
    private long connectionTimeout = 1800000L;
    private long retryInterval = 5000L;

    public MQExchangeBindingService(IRabbitMQService rabbitMQService) {
        this.rabbitMQService = rabbitMQService;
    }

    public String getServiceName() {
        return EXCHANGE_BINDING_SERVICE;
    }

    public void start() {
        this.scheduler = new Scheduler(EXCHANGE_BINDING_SERVICE, 2, 2);
    }

    public void updateExchangeBinding(List<ComponentType> components) {
        List<String> newByPassFilters = this.getFilters(components);
        if (this.isFilterChanged(newByPassFilters) || !this.bindingInited) {
            try {
                if (ServiceLookup.findClusterService().isMaster()) {
                    this.scheduler.schedule(() -> this.update(newByPassFilters));
                }
                this.bindingInited = true;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Failed to create binding for bypass message", (Throwable)e);
            }
        }
    }

    private Void update(List<String> newByPassFilters) {
        try {
            this.executeUpdateBinding(newByPassFilters);
        }
        catch (AlreadyClosedException e) {
            this.handleRecovery(e);
            this.executeUpdateBinding(newByPassFilters);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to update by-pass binding to  RabbitMQ", (Throwable)e);
            throw new IllegalStateException(e);
        }
        return null;
    }

    private void executeUpdateBinding(List<String> newByPassFilters) {
        this.rabbitMQService.updateExchangBinding(this.getAllComponentNames(), newByPassFilters);
        this.byPassFilters.clear();
        this.byPassFilters.addAll(newByPassFilters);
    }

    private List<String> getAllComponentNames() {
        return this.getFilters(Lists.newArrayList((Object[])ComponentType.values()));
    }

    private List<String> getFilters(List<ComponentType> components) {
        ArrayList filters = Lists.newArrayList();
        for (ComponentType componentType : components) {
            filters.add(componentType.toString());
        }
        return filters;
    }

    private boolean isFilterChanged(List<String> filters) {
        boolean isSame = this.byPassFilters.containsAll(filters) && filters.containsAll(this.byPassFilters);
        return !isSame;
    }

    private void handleRecovery(AlreadyClosedException e) {
        String msg = "During update by-pass binding, cannot connect to RabbitMQ due to error:" + e.getMessage() + ", try to re-setup the connection.";
        LOGGER.error((Object)msg);
        Boolean started = (Boolean)ServiceLookup.forceExecute(() -> {
            this.rabbitMQService.recoverConnection();
            return true;
        }, (String)"creat the connection to RabbitMQ ", (long)this.connectionTimeout, (long)this.retryInterval);
        if (started == null || !started.booleanValue()) {
            throw new IllegalStateException("Failed to connect to RabbitMQ after a few retries in " + this.connectionTimeout + " ms.");
        }
        LOGGER.info((Object)"Re-Connected to RabbitMQ after last failure, try to update by-pass binding now");
    }

    public void stop() {
        this.scheduler.stop();
    }
}

