/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.internal;

import com.tandbergtv.workflow.adaptor.AdaptorRuntimeException;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.conf.IMessageProcessorConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherFactory;
import com.tandbergtv.workflow.adaptor.dispatcher.IDispatcher;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.adaptor.handler.HandlerFactory;
import com.tandbergtv.workflow.adaptor.handler.IHandler;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessageUID;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;

public class DefaultAdaptorContext {
    private static final Logger LOGGER = Logger.getLogger(DefaultAdaptorContext.class);
    private Map<IDestination, IDispatcher> dispatchers;
    private Map<IMessageUID, IMessageProcessorConfiguration> configuration = new ConcurrentHashMap<IMessageUID, IMessageProcessorConfiguration>();
    private Map<String, Class<?>> handlerClasses;
    private Map<String, Class<?>> dispatcherClasses;

    public DefaultAdaptorContext() {
        this.dispatchers = new ConcurrentHashMap<IDestination, IDispatcher>();
        this.handlerClasses = new ConcurrentHashMap();
        this.dispatcherClasses = new ConcurrentHashMap();
    }

    public void destroy() {
        this.releaseClassLoader();
        this.configuration.clear();
        this.dispatcherClasses.clear();
        this.handlerClasses.clear();
        this.dispatchers.clear();
    }

    private void releaseClassLoader() {
        for (IMessageProcessorConfiguration dispatch : this.configuration.values()) {
            ClassLoader loader = dispatch.getDispatcherConfiguration().getClassLoader();
            if (loader == null || !(loader instanceof PluginClassLoader)) continue;
            try {
                ((PluginClassLoader)PluginClassLoader.class.cast(loader)).close();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to close the class loader for dispatch: " + dispatch), (Throwable)e);
            }
        }
    }

    public IMessageProcessorConfiguration getConfiguration(IMessageUID uid) {
        return this.configuration.get(uid);
    }

    public List<IDestination> getDestinations(IMessageUID uid) {
        if (this.configuration.get(uid) == null) {
            throw new AdaptorRuntimeException("Unknown message [" + uid + "]");
        }
        return this.configuration.get(uid).getDestinations();
    }

    public void addConfiguration(IMessageUID uid, IMessageProcessorConfiguration configuration) {
        this.configuration.put(uid, configuration);
    }

    public IHandler getHandler(IMessageProcessorConfiguration conf) throws HandlerException {
        IHandlerConfiguration hc = conf.getHandlerConfiguration();
        String uid = hc.getMessageUID();
        HandlerFactory factory = HandlerFactory.newInstance();
        if (this.handlerClasses.containsKey(uid)) {
            return factory.createHandler(this.handlerClasses.get(uid), hc);
        }
        IHandler handler = factory.createHandler(hc);
        this.handlerClasses.putIfAbsent(uid, handler.getClass());
        return handler;
    }

    public IDispatcher getDispatcher(IMessageProcessorConfiguration conf, IDestination dst) throws DispatcherException {
        IDispatcherConfiguration c = conf.getDispatcherConfiguration();
        IDispatcher dispatcher = this.dispatchers.get(dst);
        if (dispatcher == null) {
            String uid = c.getMessageUID();
            DispatcherFactory factory = DispatcherFactory.newInstance();
            dispatcher = this.dispatcherClasses.containsKey(uid) ? factory.createDispatcher(this.dispatcherClasses.get(uid), c, dst) : factory.createDispatcher(c, dst);
            this.dispatcherClasses.putIfAbsent(uid, dispatcher.getClass());
            if (c.isStateful()) {
                this.dispatchers.put(dst, dispatcher);
            }
        }
        return dispatcher;
    }
}

