/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.dao.hibernate;

import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibernateUtil {
    private static SessionFactory sessionFactory;
    private static DataSource dataSource;
    private static final String HIBERNATE_CONFIG_RESOURCE = "/com/tandbergtv/workflow/dao/hibernate.cfg.xml";
    private static final Logger logger;

    public static void initialize() {
        try {
            Configuration configuration = new Configuration();
            configuration.configure(HIBERNATE_CONFIG_RESOURCE);
            sessionFactory = configuration.buildSessionFactory();
        }
        catch (Throwable ex) {
            logger.warn((Object)("Errors in initializing Hibernate Configuration: " + ex));
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public static void setSessionFactory(SessionFactory sessionFactory) {
        HibernateUtil.sessionFactory = sessionFactory;
    }

    public static DataSource getDataSource() {
        return dataSource;
    }

    public static void close() {
        if (sessionFactory != null) {
            sessionFactory.close();
            sessionFactory = null;
        }
    }

    static {
        logger = Logger.getLogger(HibernateUtil.class);
    }
}

