/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.driver.command.BaseTokenCommand;
import com.tandbergtv.workflow.driver.command.locate.TokenLocatorException;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.message.queue.RejectExecutionMessageExecption;
import com.tandbergtv.workflow.message.WorkflowMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public class RecoverCommand
extends BaseTokenCommand {
    private static final long serialVersionUID = -8807350638061232290L;
    private static final Logger LOGGER = Logger.getLogger(RecoverCommand.class);

    public RecoverCommand(WorkflowMessage message) {
        super(message);
    }

    @Override
    protected Token getToken() throws TokenLocatorException {
        CustomToken token = this.loadToken(this.message);
        if (this.isUnRecoverable(token)) {
            throw new TokenLocatorException("Recover from status " + token.getStatus() + " is not allowed");
        }
        this.cacheProcess(token);
        return token;
    }

    @Override
    protected WorkflowMessage executeImpl(Token token) {
        try {
            CustomToken rootToken = (CustomToken)token;
            if (this.isUnRecoverable(rootToken)) {
                String errorMsg = "The recover message[" + this.message.getCreateId() + "] status[ " + rootToken.getStatus() + "] is wrong , reject the handling";
                throw new RejectExecutionMessageExecption(errorMsg, false);
            }
            this.recover(rootToken);
            String subTokenIds = this.message.getCommand().getParameterValue("subProcessTokens");
            if (StringUtils.isNotBlank((String)subTokenIds)) {
                this.recoverSubProcesses(subTokenIds);
            }
        }
        catch (RejectExecutionMessageExecption e) {
            throw e;
        }
        catch (Exception e) {
            return this.createErrorResponse(e.getMessage());
        }
        return this.createSuccessResponse();
    }

    private boolean isUnRecoverable(CustomToken rootToken) {
        return !rootToken.getProcessInstance().getCanBeRecovered();
    }

    private void recoverSubProcesses(String subTokenIds) throws TokenLocatorException, InterruptedException {
        String[] ids = StringUtils.split((String)subTokenIds, (String)",");
        LOGGER.info((Object)("Found " + ids.length + " sub processes to recover." + subTokenIds));
        for (String id : ids) {
            CustomToken subToken = this.loadToken(Configuration.toLong((String)id, (long)-1L));
            LOGGER.debug((Object)("Recovering  sub process [" + subToken + "]"));
            this.recover(subToken);
        }
    }

    private void recover(CustomToken token) {
        ServiceLookup.findProcessManagerService().recover(token);
    }

    @Override
    public WorkflowMessage execute() {
        try {
            return this.executeImpl(this.getToken());
        }
        catch (TokenLocatorException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.logMessage(this.message);
            return this.createErrorResponse(e.getMessage());
        }
    }
}

