/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.command.BaseTokenCommand;
import com.tandbergtv.workflow.driver.command.locate.TokenLocatorException;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.Serializable;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public class RestartCommand
extends BaseTokenCommand {
    private static final long serialVersionUID = 5421165182499573659L;
    private static final Logger LOGGER = Logger.getLogger(RestartCommand.class);

    public RestartCommand(WorkflowMessage message) {
        super(message);
    }

    @Override
    protected WorkflowMessage executeImpl(Token token) {
        WorkflowMessage ack = this.createSuccessResponse();
        try {
            long pid = token.getProcessInstance().getId();
            WorkflowProcess process = ServiceLookup.findProcessPersistenceService().get((Serializable)Long.valueOf(pid));
            Future f = ServiceLookup.findProcessManagerService().restart(process, this.message.getCreateId());
            ack.getPayload().putValue("NewRequestKey", Long.toString(((CustomToken)f.get()).getId()));
        }
        catch (Exception e) {
            return this.createErrorResponse(e.getMessage());
        }
        return ack;
    }

    @Override
    public WorkflowMessage execute() {
        try {
            return this.executeImpl(this.getToken());
        }
        catch (TokenLocatorException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.logMessage(this.message);
            return this.createErrorResponse(e.getMessage());
        }
    }

    @Override
    protected Token getToken() throws TokenLocatorException {
        CustomToken token = this.loadToken(this.message);
        if (!token.isRoot()) {
            token = token.getProcessInstance().getRootToken();
        }
        if (!token.getProcessInstance().getCanBeRestarted()) {
            throw new TokenLocatorException("Restart from status " + token.getStatus() + " is not allowed");
        }
        this.cacheProcess(token);
        return token;
    }
}

