/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.driver.command.BaseTokenCommand;
import com.tandbergtv.workflow.driver.command.locate.TokenLocatorException;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.message.WorkflowMessage;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public class ResumeCommand
extends BaseTokenCommand {
    private static final long serialVersionUID = 6438434139082409902L;
    private static final Logger LOGGER = Logger.getLogger(ResumeCommand.class);

    public ResumeCommand(WorkflowMessage message) {
        super(message);
    }

    @Override
    protected Token getToken() throws TokenLocatorException {
        CustomToken token = this.loadToken(this.message);
        if (!token.getProcessInstance().getCanBeResumed()) {
            throw new TokenLocatorException("Resume from status " + token.getStatus() + " is not allowed");
        }
        this.cacheProcess(token);
        return token;
    }

    @Override
    protected WorkflowMessage executeImpl(Token token) {
        try {
            ServiceLookup.findProcessManagerService().resume((CustomToken)token);
        }
        catch (Exception e) {
            return this.createErrorResponse(e.getMessage());
        }
        return this.createSuccessResponse();
    }

    @Override
    public WorkflowMessage execute() {
        try {
            return this.executeImpl(this.getToken());
        }
        catch (TokenLocatorException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.logMessage(this.message);
            return this.createErrorResponse(e.getMessage());
        }
    }
}

