/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.command.BaseTokenCommand;
import com.tandbergtv.workflow.driver.command.locate.TokenLocatorException;
import com.tandbergtv.workflow.driver.event.message.TaskCompleteEvent;
import com.tandbergtv.workflow.driver.internal.IncomingMessageService;
import com.tandbergtv.workflow.driver.service.IIncomingMessageService;
import com.tandbergtv.workflow.exe.resource.RequestResource;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.CommandException;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class TaskCompleteCommand
extends BaseTokenCommand {
    private static final long serialVersionUID = 4386596988441541175L;
    private List<ProcessStatus> processStatus = Lists.newArrayList((Object[])new ProcessStatus[]{ProcessStatus.BUSY, ProcessStatus.RUNNING, ProcessStatus.QUEUED, ProcessStatus.PAUSED});
    private static final Logger LOGGER = Logger.getLogger(TaskCompleteCommand.class);

    public TaskCompleteCommand(WorkflowMessage message) {
        super(message);
    }

    @Override
    protected WorkflowMessage executeImpl(Token token) {
        try {
            if (token.getNode() instanceof ManualTaskNode) {
                TaskInstance ti = this.getTaskInstance(token);
                if (ti == null) {
                    return this.createErrorResponse("No suitable manual task found");
                }
                this.copyVariables(ti);
                if (this.message.getType() == WorkflowMessage.MessageType.nack) {
                    ((CustomToken)token).fail(ErrorCategory.NACK, (String)this.message.getParameterValue("error-message"));
                } else {
                    ti.end();
                }
            } else {
                IIncomingMessageService service = (IIncomingMessageService)ServiceRegistry.getDefault().lookup(IIncomingMessageService.class);
                service.offerMessage(token, this.message);
                if (IncomingMessageService.isPasueAsyncMessageNode((CustomToken)((CustomToken)token))) {
                    this.sendAcquireResourceEvent((CustomToken)token);
                }
            }
        }
        catch (CommandException e) {
            return this.createErrorResponse(e.getMessage());
        }
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new TaskCompleteEvent((Object)this, token, this.message));
        return this.createSuccessResponse();
    }

    private void sendAcquireResourceEvent(CustomToken token) {
        try {
            this.cacheProcess(token);
        }
        catch (TokenLocatorException e) {
            LOGGER.error((Object)e);
        }
        RequestResource requestResource = new RequestResource();
        requestResource.sendAcquireResourceEvent(token, (ExecutionContext)new com.tandbergtv.workflow.core.graph.exe.ExecutionContext((Token)token));
    }

    private TaskInstance getTaskInstance(Token token) {
        Collection instances;
        TaskMgmtInstance tmi = token.getProcessInstance().getTaskMgmtInstance();
        if (tmi != null && (instances = tmi.getTaskInstances()) != null) {
            for (TaskInstance ti : instances) {
                if (ti.hasEnded() || !token.equals((Object)ti.getToken())) continue;
                return ti;
            }
        }
        return null;
    }

    private void copyVariables(TaskInstance ti) {
        List variables = ti.getTask().getTaskController().getVariableAccesses();
        for (TaskVariable variable : variables) {
            String name = variable.getMappedName();
            LOGGER.debug((Object)(ti.getToken() + ", variable " + name));
            if (!variable.isWritable()) continue;
            Object value = this.message.getParameterValue(name);
            LOGGER.debug((Object)(ti.getToken() + ", value " + value));
            if (value == null) continue;
            ti.setVariable(name, value);
        }
    }

    @Override
    protected void checkStatus(CustomToken token) throws TokenLocatorException {
        ProcessStatus status = token.getStatus();
        if (this.processStatus.contains(status)) {
            return;
        }
        if (IncomingMessageService.isPasueAsyncMessageNode((CustomToken)token)) {
            return;
        }
        throw new TokenLocatorException("Message [" + this.message.getMessageUID() + "]: found process " + token + ", status is unexpected");
    }
}

