/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.config;

import com.ericsson.cms.neptune.rabbitmq.workflow.WorkflowExchangeType;
import com.ericsson.cms.neptune.rabbitmq.workflow.WorkflowQueueType;
import com.tandbergtv.workflow.driver.message.queue.ArchiveMessageConsumer;
import com.tandbergtv.workflow.driver.message.queue.ArchiveMessageProcessorImpl;
import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.Declarables;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WorkOrderArchiveConfiguration {
    public static final String ARCHIVED_DLX_EXCHANGE_NAME = WorkflowExchangeType.ARCHIVEDDLX.toString();
    public static final String ARCHIVED_EXCHANGE_NAME = WorkflowExchangeType.ARCHIVED.toString();
    public static final String ARCHIVED_QUEUE_NAME = WorkflowQueueType.ARCHIVE.toString();
    public static final String ARCHIVED_RETRY_QUEUE_NAME = WorkflowQueueType.ARCHIVERETRY.toString();
    public static final String MATCH_ALL = "#";

    @Bean
    public Declarables archiveDeclarables() {
        Exchange archvedExchange = ExchangeBuilder.directExchange((String)ARCHIVED_EXCHANGE_NAME).durable(false).build();
        Exchange archvedDlxExchange = ExchangeBuilder.directExchange((String)ARCHIVED_DLX_EXCHANGE_NAME).durable(false).build();
        Queue archivedRetryQueue = QueueBuilder.durable((String)ARCHIVED_RETRY_QUEUE_NAME).withArguments(WorkOrderArchiveConfiguration.getDlxQueueAgrument()).build();
        Queue archivedQueue = QueueBuilder.durable((String)ARCHIVED_QUEUE_NAME).build();
        Binding dlxBinding = BindingBuilder.bind((Queue)archivedQueue).to(archvedDlxExchange).with(MATCH_ALL).noargs();
        Binding archivedBinding = BindingBuilder.bind((Queue)archivedQueue).to(archvedExchange).with(ARCHIVED_QUEUE_NAME).noargs();
        Binding retryBinding = BindingBuilder.bind((Queue)archivedRetryQueue).to(archvedExchange).with(ARCHIVED_RETRY_QUEUE_NAME).noargs();
        return new Declarables(new Declarable[]{archvedExchange, archvedDlxExchange, archivedRetryQueue, archivedQueue, dlxBinding, archivedBinding, retryBinding});
    }

    @Bean
    public ArchiveMessageConsumer archiveMessageConsumer() {
        ArchiveMessageConsumer archiveMessageConsumer = new ArchiveMessageConsumer();
        archiveMessageConsumer.setArchiveMessageProcessor(new ArchiveMessageProcessorImpl());
        return archiveMessageConsumer;
    }

    private static Map<String, Object> getDlxQueueAgrument() {
        HashMap<String, Object> agrument = new HashMap<String, Object>();
        agrument.put("x-dead-letter-exchange", ARCHIVED_DLX_EXCHANGE_NAME);
        agrument.put("x-dead-letter-routing-key", MATCH_ALL);
        return agrument;
    }
}

