/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.WFSearchProgressStatusResult;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.message.queue.ArchiveMessagesUtils;
import com.tandbergtv.workflow.driver.message.queue.IArchiveMessageProcessor;
import com.tandbergtv.workflow.driver.process.archived.IWorkOrderArchiveService;
import com.tandbergtv.workflow.message.ArchiveMessage;
import com.tandbergtv.workflow.message.ArchiveMessageChunk;
import com.tandbergtv.workflow.message.producer.IArchiveMessageProducer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArchiveMessageProcessorImpl
implements IArchiveMessageProcessor {
    private static final Logger LOGGER = Logger.getLogger(ArchiveMessageProcessorImpl.class);
    private IWorkOrderArchiveService workOrderArchiveService = ServiceLookup.findWorkOrderArchiveService();

    @Override
    public Boolean processMessages(ArchiveMessageChunk archiveMessages) {
        WFSearchProgressStatusResult archiveStatusResult;
        if (archiveMessages.isEmpty()) {
            return false;
        }
        try {
            archiveStatusResult = this.queryArchiveStatus(archiveMessages.getInProgressMessageWoIds());
        }
        catch (Exception e) {
            return this.publishRetryMessage(archiveMessages.getArchiveMessageList());
        }
        if (!this.messageInprogressToRetry(archiveMessages.getInProgressMessageMap(), archiveStatusResult.getInProgressWoIds())) {
            return false;
        }
        List<Long> archiveWoIds = this.getToArchiveWoIds(archiveStatusResult.getErrorWoIds(), archiveMessages.getNotInProgressMessageWoIds());
        return this.preformArchive(archiveMessages.getArchiveMessageMap(), archiveWoIds);
    }

    private boolean messageInprogressToRetry(Map<Long, ArchiveMessage> inProgressMessageMap, List<Long> inProcessToRetryWoIds) {
        if (inProgressMessageMap.isEmpty()) {
            return true;
        }
        List<ArchiveMessage> inprogressToRetrysMessage = ArchiveMessagesUtils.getMessagesListByIds(inProgressMessageMap, inProcessToRetryWoIds);
        return this.publishRetryMessage(inprogressToRetrysMessage);
    }

    public boolean preformArchive(Map<Long, ArchiveMessage> archiveMessageMap, List<Long> archiveWoIds) {
        if (archiveWoIds.isEmpty()) {
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Ready to archive work order ids :" + archiveWoIds.toString()));
        }
        try {
            List failedWoIds = this.workOrderArchiveService.archiveWorkOrders(archiveWoIds);
            return this.messageArchiveFailedToRetry(archiveMessageMap, failedWoIds);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Archive exception:" + e));
            return this.messageArchiveFailedToRetry(archiveMessageMap, archiveWoIds);
        }
    }

    public boolean messageArchiveFailedToRetry(Map<Long, ArchiveMessage> archiveMessageMap, List<Long> failedWoIds) {
        if (failedWoIds.isEmpty()) {
            return true;
        }
        List<ArchiveMessage> archiveFailedMessages = ArchiveMessagesUtils.getMessagesListByIds(archiveMessageMap, failedWoIds);
        ArchiveMessagesUtils.setNoInProgress(archiveFailedMessages);
        return this.publishRetryMessage(archiveFailedMessages);
    }

    private List<Long> getToArchiveWoIds(List<Long> inprogressToArchiveWoIds, List<Long> noInProgressWoIds) {
        ArrayList archiveWoIds = Lists.newArrayList(inprogressToArchiveWoIds);
        archiveWoIds.addAll(noInProgressWoIds);
        return archiveWoIds;
    }

    private WFSearchProgressStatusResult queryArchiveStatus(List<Long> inProgressWoIds) {
        if (inProgressWoIds.isEmpty()) {
            return new WFSearchProgressStatusResult();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Get In-progress work order ids:" + inProgressWoIds.toString()));
        }
        try {
            return ServiceLookup.findProcessSearchService().searchProgressStatusById(inProgressWoIds);
        }
        catch (Exception e) {
            LOGGER.error((Object)("query in progress work order status exception" + e));
            throw e;
        }
    }

    private boolean publishRetryMessage(List<ArchiveMessage> retryMessageList) {
        ArchiveMessagesUtils.discardMessageByRetryCount(retryMessageList);
        if (retryMessageList.isEmpty()) {
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("publish to retry:" + retryMessageList.toString()));
        }
        try {
            ((IArchiveMessageProducer)ServiceRegistry.getDefault().lookup(IArchiveMessageProducer.class)).batchPublishToRetry(retryMessageList);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Publish to retry error:" + e));
            return false;
        }
        return true;
    }

    public void setWorkOrderArchiveService(IWorkOrderArchiveService workOrderArchiveService) {
        this.workOrderArchiveService = workOrderArchiveService;
    }
}

