/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.message.ArchiveMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArchiveMessagesUtils {
    private static final Logger LOGGER = Logger.getLogger(ArchiveMessagesUtils.class);
    private static final int MAX_RETRY_TIMES = 3;

    private ArchiveMessagesUtils() {
    }

    public static void discardMessageByRetryCount(List<ArchiveMessage> messages) {
        ArrayList removeList = Lists.newArrayList();
        Iterator<ArchiveMessage> iterator = messages.iterator();
        while (iterator.hasNext()) {
            ArchiveMessage message = iterator.next();
            message.incrRetryCount();
            if (message.getRetryCount() <= 3) continue;
            removeList.add(message.getProcessId());
            iterator.remove();
        }
        if (!removeList.isEmpty()) {
            LOGGER.warn((Object)("Retry exceeds maximum threhold, [" + removeList.size() + "] are discarded:" + ((Object)removeList).toString()));
        }
    }

    public static void setNoInProgress(List<ArchiveMessage> messagess) {
        for (ArchiveMessage message : messagess) {
            message.setInProgress(Boolean.valueOf(false));
        }
    }

    public static List<ArchiveMessage> getMessagesListByIds(Map<Long, ArchiveMessage> messageMap, List<Long> ids) {
        if (messageMap.isEmpty() || ids.isEmpty()) {
            Collections.emptyList();
        }
        ArrayList msglist = Lists.newArrayList();
        for (Long id : ids) {
            if (!messageMap.keySet().contains(id)) continue;
            msglist.add(messageMap.get(id));
        }
        return msglist;
    }
}

