/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.tandbergtv.workflow.driver.message.queue.IMessageProcessor;
import com.tandbergtv.workflow.driver.message.queue.RejectExecutionMessageExecption;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.ICommandExecutor;
import com.tandbergtv.workflow.message.command.ICreateIDCommandExecutorStrategy;
import com.tandbergtv.workflow.message.command.internal.CommandExecutor;
import com.tandbergtv.workflow.message.command.internal.CreateIDCommandExecutorStrategy;
import org.apache.log4j.Logger;

public class MessageProcessorImpl
implements IMessageProcessor {
    private static final Logger LOGGER = Logger.getLogger(MessageProcessorImpl.class);
    ICommandExecutor executor;
    ICreateIDCommandExecutorStrategy createIdStrategy;

    public MessageProcessorImpl(CommandExecutor cmdExecutor, CreateIDCommandExecutorStrategy duplicatedStrategy) {
        this.executor = cmdExecutor;
        this.createIdStrategy = duplicatedStrategy;
    }

    @Override
    public Boolean processMessage(WorkflowMessage wfsMessage, Boolean isRedelivery) {
        Boolean isSuccessful = Boolean.TRUE;
        try {
            if (!this.createIdStrategy.canExecuteImmediate(wfsMessage, isRedelivery).booleanValue()) {
                String message = "Work Order has been created. Not neccessary to execute for message: " + wfsMessage.toString();
                LOGGER.info((Object)message);
                throw new RejectExecutionMessageExecption(message);
            }
            LOGGER.debug((Object)("Start to Execute message:" + wfsMessage.getCreateId()));
            WorkflowMessage response = this.executor.executeImmediate(wfsMessage);
            if (response.isErrorMessage()) {
                throw new RejectExecutionMessageExecption(response.getErrorMessage());
            }
            LOGGER.debug((Object)("Handled message:" + wfsMessage.getCreateId()));
            isSuccessful = this.isProcessed(response);
        }
        catch (Exception e) {
            this.handleRejectMessage(e);
            LOGGER.error((Object)("Unable to process the RabbitMQ message: " + wfsMessage), (Throwable)e);
            isSuccessful = Boolean.FALSE;
        }
        return isSuccessful;
    }

    private void handleRejectMessage(Exception e) {
        if (e instanceof RejectExecutionMessageExecption) {
            throw (RejectExecutionMessageExecption)e;
        }
        if (e.getCause() != null && e.getCause() instanceof RejectExecutionMessageExecption) {
            throw (RejectExecutionMessageExecption)e.getCause();
        }
    }

    private boolean isProcessed(WorkflowMessage response) {
        return response != null;
    }

    public ICommandExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(ICommandExecutor executor) {
        this.executor = executor;
    }

    public ICreateIDCommandExecutorStrategy getCreateIdStrategy() {
        return this.createIdStrategy;
    }

    public void setCreateIdStrategy(ICreateIDCommandExecutorStrategy createIdStrategy) {
        this.createIdStrategy = createIdStrategy;
    }
}

