/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MessageWriter {
    protected static final Logger LOGGER = Logger.getLogger(MessageWriter.class);
    private String dir;

    public MessageWriter(String dir) {
        this.dir = dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void moveToRejectedFolder(File file) {
        try {
            File rejectedFile = new File(this.getRejectedMessageDir(), file.getName());
            this.renameExistedFile(file.getName(), rejectedFile);
            FileUtils.moveFileToDirectory((File)file, (File)new File(this.getRejectedMessageDir()), (boolean)true);
        }
        catch (IOException e1) {
            LOGGER.debug((Object)("Fail to move the message to rejected folder:" + file.getAbsolutePath()), (Throwable)e1);
        }
    }

    public String writeRejectedMessage(String messageId, String content) {
        String fileName = messageId + ".xml";
        File rejectedFile = new File(this.getRejectedMessageDir(), fileName);
        try {
            this.renameExistedFile(fileName, rejectedFile);
            FileUtils.write((File)rejectedFile, (CharSequence)content);
            return rejectedFile.getAbsolutePath();
        }
        catch (IOException e1) {
            LOGGER.debug((Object)("Fail to move the message to rejected folder:" + rejectedFile.getAbsolutePath()), (Throwable)e1);
            return null;
        }
    }

    private void renameExistedFile(String fileName, File rejectedFile) {
        if (rejectedFile.exists()) {
            String newFileName = StringUtils.removeEnd((String)fileName, (String)".xml") + "-" + System.nanoTime() + ".xml";
            rejectedFile.renameTo(new File(this.getRejectedMessageDir(), newFileName));
        }
    }

    String getRejectedMessageDir() {
        return this.dir + File.separator + "rejected";
    }
}

