/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.message.queue;

import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.queue.monitor.IQueueMonitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.message.queue.IQueueInfo;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;

final class WorkflowMessageQueueInfo
implements Service,
IQueueInfo {
    public static final String NAME = "com.tandbergtv.workflow.mq";
    private volatile int total;
    private volatile int max;
    private volatile long totalDelay;
    private volatile int size;
    private static final Logger LOGGER = Logger.getLogger(WorkflowMessageQueueInfo.class);
    public static final String MQ_MBEAN_NAME = "com.tandbergtv.watchpoint:type=Queue,name=mq";
    public static final String MQ_SERVICE_NAME = "com.tandbergtv.workflow.mq";

    public void flush() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long getAverageDelay() {
        return 0L;
    }

    public int getMaxSize() {
        return this.max;
    }

    public int getSize() {
        return this.size;
    }

    public int getTotal() {
        return this.total;
    }

    public String getServiceName() {
        return "com.tandbergtv.workflow.mq";
    }

    public void start() {
        LOGGER.debug((Object)"Starting");
        this.startMonitor();
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTING));
        LOGGER.debug((Object)"Started");
    }

    public void stop() {
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPING));
        LOGGER.debug((Object)"Stopped");
        this.stopMonitor();
    }

    @Override
    public void handledOneMessage(long delay) {
        this.totalDelay += delay;
        ++this.total;
    }

    @Override
    public void updateQueueSize(int size) {
        if (size > this.max) {
            this.max = size;
        }
        this.size = size;
    }

    public IQueueMonitor startMonitor() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        registry.register(this.getServiceName(), (Service)this);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean(this, IQueueMonitor.class);
            server.registerMBean(mbean, new ObjectName(MQ_MBEAN_NAME));
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Message  queue monitoring will not be available", (Throwable)e);
            throw new IllegalStateException("Failed to start the Queue info Monitor", e);
        }
        return this;
    }

    public void stopMonitor() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(MQ_MBEAN_NAME));
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Message  queue MBean unregistration failed");
        }
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = registry.lookup("com.tandbergtv.workflow.mq");
        if (service != null) {
            registry.unregister(service);
        }
    }
}

